/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.util.diffsets.DiffApplyingPrimitiveLongIterator;

public class DiffApplyingPrimitiveLongIteratorTest {
    @Test
    public void iterateOnlyOverAddedElementsWhenSourceIsEmpty() {
        PrimitiveLongIterator emptySource = PrimitiveLongCollections.emptyIterator();
        PrimitiveLongSet added = PrimitiveLongCollections.setOf((long[])new long[]{1L, 2L});
        PrimitiveLongSet removed = PrimitiveLongCollections.setOf((long[])new long[]{3L});
        PrimitiveLongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((PrimitiveLongIterator)emptySource, (PrimitiveLongSet)added, (PrimitiveLongSet)removed);
        Set resultSet = PrimitiveLongCollections.toSet((PrimitiveLongIterator)iterator);
        Assert.assertThat((Object)resultSet, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 2L}));
    }

    @Test
    public void appendSourceElementsDuringIteration() {
        PrimitiveLongIterator source = PrimitiveLongCollections.iterator((long[])new long[]{4L, 5L});
        PrimitiveLongSet added = PrimitiveLongCollections.setOf((long[])new long[]{1L, 2L});
        PrimitiveLongSet removed = PrimitiveLongCollections.setOf((long[])new long[]{3L});
        PrimitiveLongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((PrimitiveLongIterator)source, (PrimitiveLongSet)added, (PrimitiveLongSet)removed);
        Set resultSet = PrimitiveLongCollections.toSet((PrimitiveLongIterator)iterator);
        Assert.assertThat((Object)resultSet, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 2L, 4L, 5L}));
    }

    @Test
    public void doNotIterateTwiceOverSameElementsWhenItsPartOfSourceAndAdded() {
        PrimitiveLongIterator source = PrimitiveLongCollections.iterator((long[])new long[]{4L, 5L});
        PrimitiveLongSet added = PrimitiveLongCollections.setOf((long[])new long[]{1L, 4L});
        PrimitiveLongSet removed = PrimitiveLongCollections.setOf((long[])new long[]{3L});
        PrimitiveLongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((PrimitiveLongIterator)source, (PrimitiveLongSet)added, (PrimitiveLongSet)removed);
        Long[] values = ArrayUtils.toObject((long[])PrimitiveLongCollections.asArray((PrimitiveLongIterator)iterator));
        Assert.assertThat((Object)values, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Long[]{1L, 4L, 5L}));
        Assert.assertThat((Object)values, (Matcher)Matchers.arrayWithSize((int)3));
    }

    @Test
    public void doNotIterateOverDeletedElement() {
        PrimitiveLongIterator source = PrimitiveLongCollections.iterator((long[])new long[]{3L, 5L});
        PrimitiveLongSet added = PrimitiveLongCollections.setOf((long[])new long[]{1L});
        PrimitiveLongSet removed = PrimitiveLongCollections.setOf((long[])new long[]{3L});
        PrimitiveLongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((PrimitiveLongIterator)source, (PrimitiveLongSet)added, (PrimitiveLongSet)removed);
        Set resultSet = PrimitiveLongCollections.toSet((PrimitiveLongIterator)iterator);
        Assert.assertThat((Object)resultSet, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 5L}));
    }

    @Test
    public void closeResource() {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        PrimitiveLongResourceIterator source = PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.emptyIterator(), (Resource)resource);
        PrimitiveLongResourceIterator iterator = DiffApplyingPrimitiveLongIterator.augment((PrimitiveLongResourceIterator)source, (PrimitiveLongSet)PrimitiveLongCollections.emptySet(), (PrimitiveLongSet)PrimitiveLongCollections.emptySet());
        iterator.close();
        ((Resource)Mockito.verify((Object)resource)).close();
    }
}

