/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.info;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.info.CannedJvmMetadataRepository;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;

public class JVMCheckerTest {
    @Test
    public void shouldIssueWarningWhenUsingHotspotServerVmVersion7() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.7.0-b147")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8, OpenJDK(TM) 8 or IBM J9."));
    }

    @Test
    public void shouldNotIssueWarningWhenUsingHotspotServerVmVersion8() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.8.0_45")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldNotIssueWarningWhenUsingIbmJ9Vm() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("IBM J9 VM", "1.8")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertTrue((boolean)bufferingLogger.toString().isEmpty());
    }

    @Test
    public void shouldIssueWarningWhenUsingHotspotServerVmVersion7InThe32BitVersion() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) Server VM", "1.7.0_25-b15")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8, OpenJDK(TM) 8 or IBM J9."));
    }

    @Test
    public void shouldIssueWarningWhenUsingOpenJDKServerVmVersion7() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("OpenJDK 64-Bit Server VM", "1.7.0-b147")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8, OpenJDK(TM) 8 or IBM J9."));
    }

    @Test
    public void shouldIssueWarningWhenUsingOpenJDKClientVmVersion7() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("OpenJDK Client VM", "1.7.0-b147")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8, OpenJDK(TM) 8 or IBM J9."));
    }

    @Test
    public void shouldIssueWarningWhenUsingUnsupportedJvm() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("MyOwnJDK 64-Bit Awesome VM", "1.7")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8, OpenJDK(TM) 8 or IBM J9."));
    }

    @Test
    public void shouldIssueWarningWhenUsingUnsupportedJvmVersion() {
        BufferingLog bufferingLogger = new BufferingLog();
        new JvmChecker((Log)bufferingLogger, (JvmMetadataRepository)new CannedJvmMetadataRepository("Java HotSpot(TM) 64-Bit Server VM", "1.6.42_87")).checkJvmCompatibilityAndIssueWarning();
        Assert.assertThat((Object)bufferingLogger.toString().trim(), (Matcher)Is.is((Object)"You are using an unsupported version of the Java runtime. Please use Oracle(R) Java(TM) Runtime Environment 8, OpenJDK(TM) 8 or IBM J9."));
    }
}

