/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.dump;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DumpProcessInformation {
    private static final String HEAP = "heap";
    private static final String DIR = "dir";
    private final Log log;
    private final File outputDirectory;

    public static void main(String[] args) throws Exception {
        Args arg = Args.withFlags((String[])new String[]{HEAP}).parse(args == null ? new String[]{} : args);
        boolean doHeapDump = arg.getBoolean(HEAP, Boolean.valueOf(false), Boolean.valueOf(true));
        String[] containing = arg.orphans().toArray(new String[arg.orphans().size()]);
        String dumpDir = arg.get(DIR, "data");
        new DumpProcessInformation((LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), new File(dumpDir)).dumpRunningProcesses(doHeapDump, containing);
    }

    public DumpProcessInformation(LogProvider logProvider, File outputDirectory) {
        this.log = logProvider.getLog(this.getClass());
        this.outputDirectory = outputDirectory;
    }

    public void dumpRunningProcesses(boolean includeHeapDump, String ... javaPidsContainingClassNames) throws Exception {
        this.outputDirectory.mkdirs();
        for (Pair<Long, String> pid : this.getJPids((Matcher<String>)Matchers.isIn((Object[])javaPidsContainingClassNames))) {
            this.doThreadDump(pid);
            if (!includeHeapDump) continue;
            this.doHeapDump(pid);
        }
    }

    public File doThreadDump(Pair<Long, String> pid) throws Exception {
        File outputFile = new File(this.outputDirectory, DumpProcessInformation.fileName("threaddump", pid));
        this.log.info("Creating thread dump of " + pid + " to " + outputFile.getAbsolutePath());
        String[] cmdarray = new String[]{"jstack", "" + pid.first()};
        Process process = Runtime.getRuntime().exec(cmdarray);
        this.writeProcessOutputToFile(process, outputFile);
        return outputFile;
    }

    public void doHeapDump(Pair<Long, String> pid) throws Exception {
        File outputFile = new File(this.outputDirectory, DumpProcessInformation.fileName("heapdump", pid));
        this.log.info("Creating heap dump of " + pid + " to " + outputFile.getAbsolutePath());
        String[] cmdarray = new String[]{"jmap", "-dump:file=" + outputFile.getAbsolutePath(), "" + pid.first()};
        Runtime.getRuntime().exec(cmdarray).waitFor();
    }

    public void doThreadDump(Matcher<String> processFilter) throws Exception {
        for (Pair<Long, String> pid : this.getJPids(processFilter)) {
            this.doThreadDump(pid);
        }
    }

    public Collection<Pair<Long, String>> getJPids(Matcher<String> filter) throws Exception {
        Process process = Runtime.getRuntime().exec(new String[]{"jps", "-l"});
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        ArrayList<Pair<Long, String>> jPids = new ArrayList<Pair<Long, String>>();
        ArrayList<String> excludedJPids = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String pid;
            int spaceIndex = line.indexOf(32);
            String name = line.substring(spaceIndex + 1);
            if (name.contains(":")) {
                name = pid = line.substring(0, spaceIndex);
            }
            pid = Pair.of((Object)Long.parseLong(line.substring(0, spaceIndex)), (Object)name);
            if (name.contains(DumpProcessInformation.class.getSimpleName()) || name.contains("Jps") || name.contains("eclipse.equinox") || !filter.matches((Object)name)) {
                excludedJPids.add(pid);
                continue;
            }
            jPids.add((Pair<Long, String>)pid);
        }
        process.waitFor();
        this.log.info("Found jPids:" + jPids + ", excluded:" + excludedJPids);
        return jPids;
    }

    private void writeProcessOutputToFile(Process process, File outputFile) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        try (PrintStream out = new PrintStream(outputFile);){
            while ((line = reader.readLine()) != null) {
                out.println(line);
            }
        }
        process.waitFor();
    }

    private static String fileName(String category, Pair<Long, String> pid) {
        return Format.time().replace(':', '_').replace('.', '_') + "-" + category + "-" + pid.first() + "-" + (String)pid.other();
    }
}

