/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.ForcedSecondaryUnitRecordFormats;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

@RunWith(value=Parameterized.class)
public class RelationshipGroupDefragmenterTest {
    private static final Configuration CONFIG = Configuration.DEFAULT;
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final RandomRule random = new RandomRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.random).around((TestRule)this.fileSystemRule);
    @Parameterized.Parameter(value=0)
    public RecordFormats format;
    @Parameterized.Parameter(value=1)
    public int units;
    private BatchingNeoStores stores;

    @Parameterized.Parameters
    public static Collection<Object[]> formats() {
        return Arrays.asList({Standard.LATEST_RECORD_FORMATS, 1}, {new ForcedSecondaryUnitRecordFormats(Standard.LATEST_RECORD_FORMATS), 2});
    }

    @Before
    public void start() throws IOException {
        this.stores = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.fileSystemRule.get(), (File)this.directory.absolutePath(), (RecordFormats)this.format, (Configuration)CONFIG, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());
        this.stores.createNew();
    }

    @After
    public void stop() throws IOException {
        this.stores.close();
    }

    @Test
    public void shouldDefragmentRelationshipGroupsWhenAllDense() {
        int nodeCount = 100;
        int relationshipTypeCount = 50;
        RecordStore groupStore = this.stores.getTemporaryRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupStore.newRecord();
        NodeStore nodeStore = this.stores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)nodeStore.newRecord();
        long cursor = 0L;
        for (int typeId = relationshipTypeCount - 1; typeId >= 0; --typeId) {
            long nodeId = 0L;
            while (nodeId < (long)nodeCount) {
                groupRecord.initialize(true, typeId, cursor, cursor + 1L, cursor + 2L, nodeId, 4L);
                groupRecord.setId(groupStore.nextId());
                groupStore.updateRecord((AbstractBaseRecord)groupRecord);
                if (typeId == 0) {
                    nodeRecord.initialize(true, -1L, true, groupRecord.getId(), 0L);
                    nodeRecord.setId(nodeId);
                    nodeStore.updateRecord((AbstractBaseRecord)nodeRecord);
                    nodeStore.setHighestPossibleIdInUse(nodeId);
                }
                ++nodeId;
                ++cursor;
            }
        }
        this.defrag(nodeCount, (RecordStore<RelationshipGroupRecord>)groupStore);
        this.verifyGroupsAreSequentiallyOrderedByNode();
    }

    @Test
    public void shouldDefragmentRelationshipGroupsWhenSomeDense() {
        int nodeCount = 100;
        int relationshipTypeCount = 50;
        RecordStore groupStore = this.stores.getTemporaryRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupStore.newRecord();
        NodeStore nodeStore = this.stores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)nodeStore.newRecord();
        long cursor = 0L;
        BitSet initializedNodes = new BitSet();
        for (int typeId = relationshipTypeCount - 1; typeId >= 0; --typeId) {
            int nodeId = 0;
            while (nodeId < nodeCount) {
                double comparison;
                double d = comparison = typeId == 0 || initializedNodes.get(nodeId) ? 0.1 : 0.001;
                if (this.random.nextDouble() < comparison) {
                    groupRecord.initialize(true, typeId, cursor, cursor + 1L, cursor + 2L, (long)nodeId, 4L);
                    groupRecord.setId(groupStore.nextId());
                    groupStore.updateRecord((AbstractBaseRecord)groupRecord);
                    if (!initializedNodes.get(nodeId)) {
                        nodeRecord.initialize(true, -1L, true, groupRecord.getId(), 0L);
                        nodeRecord.setId((long)nodeId);
                        nodeStore.updateRecord((AbstractBaseRecord)nodeRecord);
                        nodeStore.setHighestPossibleIdInUse((long)nodeId);
                        initializedNodes.set(nodeId);
                    }
                }
                ++nodeId;
                ++cursor;
            }
        }
        this.defrag(nodeCount, (RecordStore<RelationshipGroupRecord>)groupStore);
        this.verifyGroupsAreSequentiallyOrderedByNode();
    }

    private void defrag(int nodeCount, RecordStore<RelationshipGroupRecord> groupStore) {
        RelationshipGroupDefragmenter.Monitor monitor = (RelationshipGroupDefragmenter.Monitor)Mockito.mock(RelationshipGroupDefragmenter.Monitor.class);
        RelationshipGroupDefragmenter defragmenter = new RelationshipGroupDefragmenter(CONFIG, ExecutionMonitors.invisible(), monitor, NumberArrayFactory.AUTO_WITHOUT_PAGECACHE);
        long memory = groupStore.getHighId() * 15L + 200L;
        defragmenter.run(memory, this.stores, (long)nodeCount);
        ((RelationshipGroupDefragmenter.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.atLeast((int)2))).defragmentingNodeRange(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((RelationshipGroupDefragmenter.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.atMost((int)10))).defragmentingNodeRange(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    private void verifyGroupsAreSequentiallyOrderedByNode() {
        RecordStore store = this.stores.getRelationshipGroupStore();
        long firstId = store.getNumberOfReservedLowIds();
        long groupCount = store.getHighId() - firstId;
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)store.newRecord();
        RecordCursor groupCursor = store.newRecordCursor((AbstractBaseRecord)groupRecord).acquire(firstId, RecordLoad.CHECK);
        long highGroupId = store.getHighId();
        long currentNodeId = -1L;
        int currentTypeId = -1;
        int newGroupCount = 0;
        int currentGroupLength = 0;
        long id = firstId;
        while (id < highGroupId) {
            if (!groupCursor.next(id)) {
                Assert.assertTrue((this.units > 1 ? 1 : 0) != 0);
                Assert.assertTrue((currentGroupLength > 0 ? 1 : 0) != 0);
                --currentGroupLength;
            } else {
                long nodeId = groupRecord.getOwningNode();
                Assert.assertTrue((String)("Expected a group for node >= " + currentNodeId + ", but was " + nodeId + " in " + groupRecord), (nodeId >= currentNodeId ? 1 : 0) != 0);
                if (nodeId != currentNodeId) {
                    currentNodeId = nodeId;
                    currentTypeId = -1;
                    if (this.units > 1) {
                        Assert.assertEquals((long)0L, (long)currentGroupLength);
                    }
                    currentGroupLength = 0;
                }
                ++currentGroupLength;
                Assert.assertTrue((String)("Expected this group to have a next of current + " + this.units + " OR NULL, but was " + groupRecord.toString()), (groupRecord.getNext() == groupRecord.getId() + 1L || groupRecord.getNext() == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 1 : 0) != 0);
                Assert.assertTrue((String)("Expected " + groupRecord + " to have type > " + currentTypeId), (groupRecord.getType() > currentTypeId ? 1 : 0) != 0);
                currentTypeId = groupRecord.getType();
            }
            ++id;
            ++newGroupCount;
        }
        Assert.assertEquals((long)groupCount, (long)newGroupCount);
    }
}

