/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;

public class DefaultIndexProviderMap
implements IndexProviderMap {
    private final IndexProvider defaultIndexProvider;
    private final Map<IndexProvider.Descriptor, IndexProvider> indexProviders = new HashMap<IndexProvider.Descriptor, IndexProvider>();
    private final Map<String, IndexProvider> indexProvidersByName = new HashMap<String, IndexProvider>();

    public DefaultIndexProviderMap(IndexProvider defaultIndexProvider) {
        this(defaultIndexProvider, Collections.emptyList());
    }

    public DefaultIndexProviderMap(IndexProvider defaultIndexProvider, Iterable<IndexProvider> additionalIndexProviders) {
        this.defaultIndexProvider = defaultIndexProvider;
        this.put(defaultIndexProvider.getProviderDescriptor(), defaultIndexProvider);
        for (IndexProvider provider : additionalIndexProviders) {
            IndexProvider.Descriptor providerDescriptor = provider.getProviderDescriptor();
            Objects.requireNonNull(providerDescriptor);
            IndexProvider existing = this.put(providerDescriptor, provider);
            if (existing == null) continue;
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + providerDescriptor + ". First loaded " + existing + " then " + provider);
        }
    }

    private IndexProvider put(IndexProvider.Descriptor providerDescriptor, IndexProvider provider) {
        IndexProvider existing = this.indexProviders.putIfAbsent(providerDescriptor, provider);
        this.indexProvidersByName.put(providerDescriptor.name(), provider);
        return existing;
    }

    @Override
    public IndexProvider getDefaultProvider() {
        return this.defaultIndexProvider;
    }

    @Override
    public IndexProvider lookup(IndexProvider.Descriptor providerDescriptor) {
        IndexProvider provider = this.indexProviders.get(providerDescriptor);
        if (provider != null) {
            return provider;
        }
        throw this.notFound(providerDescriptor);
    }

    @Override
    public IndexProvider lookup(String providerDescriptorName) throws IndexProviderNotFoundException {
        IndexProvider provider = this.indexProvidersByName.get(providerDescriptorName);
        if (provider != null) {
            return provider;
        }
        throw this.notFound(providerDescriptorName);
    }

    private IllegalArgumentException notFound(Object key) {
        return new IllegalArgumentException("Tried to get index provider with name " + key + " whereas available providers in this session being " + Arrays.toString(this.indexProviderNames()) + ", and default being " + this.defaultIndexProvider.getProviderDescriptor().name());
    }

    @Override
    public void accept(Consumer<IndexProvider> visitor) {
        this.indexProviders.values().forEach(visitor);
    }

    private String[] indexProviderNames() {
        Collection<IndexProvider> providerList = this.indexProviders.values();
        String[] providerNames = new String[providerList.size()];
        int index = 0;
        for (IndexProvider indexProvider : providerList) {
            providerNames[index++] = indexProvider.getProviderDescriptor().name();
        }
        return providerNames;
    }
}

