/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.staging.TicketedBatch;

class Downstream {
    private static final Comparator<TicketedBatch> TICKETED_BATCH_COMPARATOR = (a, b) -> Long.compare(b.ticket, a.ticket);
    private final Step<Object> downstream;
    private final AtomicLong doneBatches;
    private final ArrayList<TicketedBatch> batches;
    private long lastSendTicket = -1L;

    Downstream(Step<Object> downstream, AtomicLong doneBatches) {
        this.downstream = downstream;
        this.doneBatches = doneBatches;
        this.batches = new ArrayList();
    }

    long send() {
        this.batches.sort(TICKETED_BATCH_COMPARATOR);
        long idleTimeSum = 0L;
        long batchesDone = 0L;
        for (int i = this.batches.size() - 1; i >= 0; --i) {
            TicketedBatch batch = this.batches.get(i);
            if (batch.ticket != this.lastSendTicket + 1L) break;
            this.batches.remove(i);
            this.lastSendTicket = batch.ticket;
            idleTimeSum += this.downstream.receive(batch.ticket, batch.batch);
            ++batchesDone;
        }
        this.doneBatches.getAndAdd(batchesDone);
        return idleTimeSum;
    }

    void queue(TicketedBatch batch) {
        if (batch.ticket != -1L && batch.batch != null) {
            this.batches.add(batch);
        }
    }
}

