/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public abstract class SchemaKernelException
extends KernelException {
    protected SchemaKernelException(Status statusCode, Throwable cause, String message, Object ... parameters) {
        super(statusCode, cause, message, parameters);
    }

    public SchemaKernelException(Status statusCode, String message, Throwable cause) {
        super(statusCode, cause, message, new Object[0]);
    }

    public SchemaKernelException(Status statusCode, String message) {
        super(statusCode, message, new Object[0]);
    }

    protected static String messageWithLabelAndPropertyName(TokenNameLookup tokenNameLookup, String formatString, SchemaDescriptor descriptor) {
        int[] propertyIds = descriptor.getPropertyIds();
        if (tokenNameLookup != null) {
            String propertyString = propertyIds.length == 1 ? "property '" + tokenNameLookup.propertyKeyGetName(propertyIds[0]) + "'" : "properties " + Arrays.stream(propertyIds).mapToObj(i -> "'" + tokenNameLookup.propertyKeyGetName(i) + "'").collect(Collectors.joining(" and "));
            return String.format(formatString, tokenNameLookup.labelGetName(descriptor.keyId()), propertyString);
        }
        String keyString = propertyIds.length == 1 ? "key[" + propertyIds[0] + "]" : "keys[" + Arrays.stream(propertyIds).mapToObj(Integer::toString).collect(Collectors.joining(", ")) + "]";
        return String.format(formatString, "label[" + descriptor.keyId() + "]", keyString);
    }

    public static enum OperationContext {
        INDEX_CREATION,
        CONSTRAINT_CREATION;

    }
}

