/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.output.EventReporter;

public class GraphiteOutput
implements Lifecycle,
EventReporter {
    private final HostnamePort hostnamePort;
    private final long period;
    private final MetricRegistry registry;
    private final Log logger;
    private final String prefix;
    private GraphiteReporter graphiteReporter;

    public GraphiteOutput(HostnamePort hostnamePort, long period, MetricRegistry registry, Log logger, String prefix) {
        this.hostnamePort = hostnamePort;
        this.period = period;
        this.registry = registry;
        this.logger = logger;
        this.prefix = prefix;
    }

    public void init() {
        Graphite graphite = new Graphite(this.hostnamePort.getHost(), this.hostnamePort.getPort());
        this.graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.registry).prefixedWith(this.prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
    }

    public void start() {
        this.graphiteReporter.start(this.period, TimeUnit.MILLISECONDS);
        this.logger.info("Sending metrics to Graphite server at " + this.hostnamePort);
    }

    public void stop() {
        this.graphiteReporter.close();
    }

    public void shutdown() {
        this.graphiteReporter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        GraphiteReporter graphiteReporter = this.graphiteReporter;
        synchronized (graphiteReporter) {
            this.graphiteReporter.report(gauges, counters, histograms, meters, timers);
        }
    }
}

