/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support.membermodification;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberMatcher {
    public static Method[] methodsDeclaredIn(Class<?> cls, Class<?> ... additionalClasses) {
        if (cls == null) {
            throw new IllegalArgumentException("You need to supply at least one class.");
        }
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(Arrays.asList(WhiteboxImpl.getAllMethods(cls)));
        for (Class<?> klass : additionalClasses) {
            methods.addAll(Arrays.asList(WhiteboxImpl.getAllMethods(klass)));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public static Method method(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        Method method = WhiteboxImpl.findMethod(declaringClass, (String)methodName, (Class[])parameterTypes);
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(declaringClass, (String)methodName, (Method)method, (Object[])parameterTypes);
        return method;
    }

    public static Method method(Class<?> declaringClass, Class<?> ... parameterTypes) {
        return Whitebox.getMethod(declaringClass, (Class[])parameterTypes);
    }

    public static Method[] methods(Class<?> clazz, String methodName, String ... additionalMethodNames) {
        return Whitebox.getMethods(clazz, (String[])MemberMatcher.merge(methodName, additionalMethodNames));
    }

    public static Method[] methods(Method method, Method ... additionalMethods) {
        return MemberMatcher.merge(method, additionalMethods);
    }

    public static Method[] methods(Class<?> clazz, String[] methodNames) {
        return Whitebox.getMethods(clazz, (String[])methodNames);
    }

    public static Field field(Class<?> declaringClass, String fieldName) {
        return Whitebox.getField(declaringClass, (String)fieldName);
    }

    public static Field[] fields(Class<?> clazz, String firstFieldName, String ... additionalfieldNames) {
        return Whitebox.getFields(clazz, (String[])MemberMatcher.merge(firstFieldName, additionalfieldNames));
    }

    public static Field[] fields(Class<?> clazz) {
        return WhiteboxImpl.getAllFields(clazz);
    }

    public static Field[] fields(Field field, Field ... additionalFields) {
        return MemberMatcher.merge(field, additionalFields);
    }

    public static Field[] fields(Class<?> clazz, String[] fieldNames) {
        return Whitebox.getFields(clazz, (String[])fieldNames);
    }

    public static <T> Constructor<T> constructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        return WhiteboxImpl.findUniqueConstructorOrThrowException(declaringClass, (Object[])parameterTypes);
    }

    public static <T> Constructor<T> constructor(Class<T> declaringClass) {
        return WhiteboxImpl.findConstructorOrThrowException(declaringClass);
    }

    public static <T> Constructor<T> defaultConstructorIn(Class<T> declaringClass) {
        return WhiteboxImpl.findDefaultConstructorOrThrowException(declaringClass);
    }

    public static Constructor<?>[] constructorsDeclaredIn(Class<?> cls, Class<?> ... additionalClasses) {
        if (cls == null) {
            throw new IllegalArgumentException("You need to supply at least one class.");
        }
        HashSet<Constructor> constructors = new HashSet<Constructor>();
        constructors.addAll(Arrays.asList(WhiteboxImpl.getAllConstructors(cls)));
        for (Class<?> klass : additionalClasses) {
            constructors.addAll(Arrays.asList(WhiteboxImpl.getAllConstructors(klass)));
        }
        return constructors.toArray(new Constructor[constructors.size()]);
    }

    public static Constructor<?>[] constructors(Constructor<?> constructor, Constructor<?> ... additionalConstructors) {
        return MemberMatcher.merge(constructor, additionalConstructors);
    }

    public static AccessibleObject[] everythingDeclaredIn(Class<?> cls, Class<?> ... additionalClasses) {
        if (cls == null) {
            throw new IllegalArgumentException("You need to supply at least one class.");
        }
        HashSet<Executable> accessibleObjects = new HashSet<Executable>();
        accessibleObjects.addAll(Collections.unmodifiableCollection(Arrays.asList(MemberMatcher.methodsDeclaredIn(cls, additionalClasses))));
        accessibleObjects.addAll(Collections.unmodifiableCollection(Arrays.asList(MemberMatcher.constructorsDeclaredIn(cls, additionalClasses))));
        return accessibleObjects.toArray(new AccessibleObject[accessibleObjects.size()]);
    }

    private static String[] merge(String first, String ... additional) {
        return (String[])new ArrayMergerImpl().mergeArrays(String.class, (Object[][])new String[][]{{first}, additional});
    }

    private static Method[] merge(Method first, Method ... additional) {
        return (Method[])new ArrayMergerImpl().mergeArrays(Method.class, (Object[][])new Method[][]{{first}, additional});
    }

    private static Field[] merge(Field first, Field ... additional) {
        return (Field[])new ArrayMergerImpl().mergeArrays(Field.class, (Object[][])new Field[][]{{first}, additional});
    }

    private static Constructor<?>[] merge(Constructor<?> first, Constructor<?> ... additional) {
        return (Constructor[])new ArrayMergerImpl().mergeArrays(Constructor.class, (Object[][])new Constructor[][]{{first}, additional});
    }
}

