/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RoutingFunction
implements Function<Object, Object> {
    public static final String FUNCTION_NAME = "functionRouter";
    private static Log logger = LogFactory.getLog(RoutingFunction.class);
    private final StandardEvaluationContext evalContext = new StandardEvaluationContext();
    private final SpelExpressionParser spelParser = new SpelExpressionParser();
    private final FunctionCatalog functionCatalog;
    private final FunctionProperties functionProperties;
    private final FunctionInspector functionInspector;

    public RoutingFunction(FunctionCatalog functionCatalog, FunctionInspector functionInspector, FunctionProperties functionProperties) {
        this(functionCatalog, functionProperties, functionInspector, null);
    }

    public RoutingFunction(FunctionCatalog functionCatalog, FunctionProperties functionProperties, FunctionInspector functionInspector, BeanResolver beanResolver) {
        this.functionCatalog = functionCatalog;
        this.functionProperties = functionProperties;
        this.functionInspector = functionInspector;
        this.evalContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.evalContext.setBeanResolver(beanResolver);
        this.evalContext.setBeanResolver(beanResolver);
    }

    @Override
    public Object apply(Object input) {
        return this.route(input, input instanceof Publisher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object route(Object input, boolean originalInputIsPublisher) {
        Function function;
        if (input instanceof Message) {
            Message message = (Message)input;
            if (StringUtils.hasText((String)((String)message.getHeaders().get((Object)"spring.cloud.function.definition")))) {
                function = this.functionFromDefinition((String)message.getHeaders().get((Object)"spring.cloud.function.definition"));
                Type functionType = this.functionInspector.getRegistration(function).getType().getType();
                if (!FunctionTypeUtils.isReactive(FunctionTypeUtils.getInputType(functionType, 0))) return function.apply(input);
                this.assertOriginalInputIsNotPublisher(originalInputIsPublisher);
                return function.apply(input);
            } else if (StringUtils.hasText((String)((String)message.getHeaders().get((Object)"spring.cloud.function.routing-expression")))) {
                function = this.functionFromExpression((String)message.getHeaders().get((Object)"spring.cloud.function.routing-expression"), message);
                Type functionType = this.functionInspector.getRegistration(function).getType().getType();
                if (!FunctionTypeUtils.isReactive(FunctionTypeUtils.getInputType(functionType, 0))) return function.apply(input);
                this.assertOriginalInputIsNotPublisher(originalInputIsPublisher);
                return function.apply(input);
            } else if (StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) {
                function = this.functionFromExpression(this.functionProperties.getRoutingExpression(), message);
                return function.apply(input);
            } else {
                if (!StringUtils.hasText((String)this.functionProperties.getDefinition())) throw new IllegalStateException("Failed to establish route, since neither were provided: 'spring.cloud.function.definition' as Message header or as application property or 'spring.cloud.function.routing-expression' as application property.");
                function = this.functionFromDefinition(this.functionProperties.getDefinition());
            }
            return function.apply(input);
        } else if (input instanceof Publisher) {
            if (StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) {
                function = this.functionFromExpression(this.functionProperties.getRoutingExpression(), input);
                return function.apply(input);
            } else {
                if (!StringUtils.hasText((String)this.functionProperties.getDefinition())) return input instanceof Mono ? Mono.from((Publisher)((Publisher)input)).map(v -> this.route(v, originalInputIsPublisher)) : Flux.from((Publisher)((Publisher)input)).map(v -> this.route(v, originalInputIsPublisher));
                function = this.functionFromDefinition(this.functionProperties.getDefinition());
            }
            return function.apply(input);
        } else {
            this.assertOriginalInputIsNotPublisher(originalInputIsPublisher);
            if (StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) {
                function = this.functionFromExpression(this.functionProperties.getRoutingExpression(), input);
                return function.apply(input);
            } else {
                if (!StringUtils.hasText((String)this.functionProperties.getDefinition())) throw new IllegalStateException("Failed to establish route, since neither were provided: 'spring.cloud.function.definition' as Message header or as application property or 'spring.cloud.function.routing-expression' as application property.");
                function = this.functionFromDefinition(this.functionProperties.getDefinition());
            }
        }
        return function.apply(input);
    }

    private void assertOriginalInputIsNotPublisher(boolean originalInputIsPublisher) {
        Assert.isTrue((!originalInputIsPublisher ? 1 : 0) != 0, (String)"Routing input of type Publisher is not supported per individual values (e.g., message header or POJO). Instead you should use 'spring.cloud.function.definition' or spring.cloud.function.routing-expression' as application properties.");
    }

    private Function functionFromDefinition(String definition) {
        Function function = (Function)this.functionCatalog.lookup(definition);
        Assert.notNull((Object)function, (String)("Failed to lookup function to route based on the value of 'spring.cloud.function.definition' property '" + this.functionProperties.getDefinition() + "'"));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Resolved function from provided [definition] property " + this.functionProperties.getDefinition()));
        }
        return function;
    }

    private Function functionFromExpression(String routingExpression, Object input) {
        Expression expression = this.spelParser.parseExpression(routingExpression);
        String functionName = (String)expression.getValue((EvaluationContext)this.evalContext, input, String.class);
        Assert.hasText((String)functionName, (String)("Failed to resolve function name based on routing expression '" + this.functionProperties.getRoutingExpression() + "'"));
        Function function = (Function)this.functionCatalog.lookup(functionName);
        Assert.notNull((Object)function, (String)("Failed to lookup function to route to based on the expression '" + this.functionProperties.getRoutingExpression() + "' whcih resolved to '" + functionName + "' function name."));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Resolved function from provided [routing-expression]  " + routingExpression));
        }
        return function;
    }
}

