package org.tio.core.cache;

import java.util.Objects;

import org.tio.utils.time.Time;

/**
 * @author tanyaowu
 * 2017年8月16日 上午10:22:25
 */
public enum CacheConfig {
	//两级缓存
	/**
	 * key: ip
	 * value: IpStat
	 */
	IP_STAT(CacheType.GUAVA, (Long) null, Time.DAY_1);
	

	public static CacheConfig from(String cacheName) {
		CacheConfig[] values = CacheConfig.values();
		for (CacheConfig v : values) {
			if (Objects.equals(v.cacheName, cacheName)) {
				return v;
			}
		}
		return null;
	}

	CacheType cacheType;
	String cacheName;
	Long timeToLiveSeconds; //单位：秒
	Long timeToIdleSeconds; //单位：秒

	/**
	 * 
	 * @param cacheType
	 * @param timeToLiveSeconds
	 * @param timeToIdleSeconds
	 * @author: tanyaowu
	 */
	private CacheConfig(CacheType cacheType, Long timeToLiveSeconds, Long timeToIdleSeconds) {
		this.cacheType = cacheType;
		this.timeToLiveSeconds = timeToLiveSeconds;
		this.timeToIdleSeconds = timeToIdleSeconds;
		this.cacheName = this.name();//.toString();
	}

	public String getCacheName() {
		return cacheName;
	}

	public CacheType getCacheType() {
		return cacheType;
	}

	public Long getTimeToIdleSeconds() {
		return timeToIdleSeconds;
	}

	public Long getTimeToLiveSeconds() {
		return timeToLiveSeconds;
	}
}
