package org.tio.core.intf;

import java.util.concurrent.CountDownLatch;

/**
 *
 * @author tanyaowu
 * 2017年4月1日 上午9:34:59
 */
public class PacketWithMeta {
	private Packet packet = null;
	private Boolean isSentSuccess = null;
	private CountDownLatch countDownLatch = null;

	/**
	 *
	 * @param packet
	 * @param countDownLatch
	 * @author tanyaowu
	 */
	public PacketWithMeta(Packet packet, CountDownLatch countDownLatch) {
		super();
		this.packet = packet;
		this.countDownLatch = countDownLatch;
		if (countDownLatch != null) {
			this.packet.setBlockSend(true);
		}
	}

	/**
	 * @return the countDownLatch
	 */
	public java.util.concurrent.CountDownLatch getCountDownLatch() {
		return countDownLatch;
	}

	/**
	 * @return the isSentSuccess
	 */
	public Boolean getIsSentSuccess() {
		return isSentSuccess;
	}

	/**
	 * @return the packet
	 */
	public Packet getPacket() {
		return packet;
	}

	/**
	 * @param isSentSuccess the isSentSuccess to set
	 */
	public void setIsSentSuccess(Boolean isSentSuccess) {
		this.isSentSuccess = isSentSuccess;
	}

}
