/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ReconnConf;
import org.tio.core.Aio;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.AioListener;
import org.tio.core.maintain.MaintainUtils;
import org.tio.core.stat.IpStat;
import org.tio.core.stat.IpStatType;
import org.tio.utils.SystemTimer;

public class CloseRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(CloseRunnable.class);
    private ChannelContext channelContext;
    private Throwable throwable;
    private String remark;
    private boolean isNeedRemove;

    public CloseRunnable(ChannelContext channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        this.channelContext = channelContext;
        this.throwable = throwable;
        this.remark = remark;
        this.isNeedRemove = isNeedRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            GroupContext groupContext = this.channelContext.getGroupContext();
            AioListener aioListener = groupContext.getAioListener();
            try {
                AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
                if (asynchronousSocketChannel != null && asynchronousSocketChannel.isOpen()) {
                    try {
                        asynchronousSocketChannel.close();
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            boolean isClientChannelContext = this.channelContext instanceof ClientChannelContext;
            boolean isRemove = this.isNeedRemove;
            if (!isRemove) {
                if (isClientChannelContext) {
                    ClientChannelContext clientChannelContext = (ClientChannelContext)this.channelContext;
                    if (!ReconnConf.isNeedReconn(clientChannelContext, false)) {
                        isRemove = true;
                    }
                } else {
                    isRemove = true;
                }
            }
            try {
                this.channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                aioListener.onBeforeClose(this.channelContext, this.throwable, this.remark, isRemove);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this.channelContext.getCloseLock();
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            boolean isLock = writeLock.tryLock();
            try {
                if (!isLock) {
                    if (!isRemove) return;
                    if (this.channelContext.isRemoved()) {
                        return;
                    }
                    writeLock.lock();
                }
                this.channelContext.traceClient(ChannelAction.UNCONNECT, null, null);
                if (this.channelContext.isClosed() && !isRemove) {
                    log.info("{}\u5df2\u7ecf\u5173\u95ed\uff0c\u5907\u6ce8:{}\uff0c\u5f02\u5e38:{}", new Object[]{this.channelContext, this.remark, this.throwable == null ? "\u65e0" : this.throwable.toString()});
                    return;
                }
                if (this.channelContext.isRemoved()) {
                    log.info("{}\u5df2\u7ecf\u5220\u9664\uff0c\u5907\u6ce8:{}\uff0c\u5f02\u5e38:{}", new Object[]{this.channelContext, this.remark, this.throwable == null ? "\u65e0" : this.throwable.toString()});
                    return;
                }
                this.channelContext.getHandlerRunnable().setCanceled(true);
                this.channelContext.getSendRunnable().setCanceled(true);
                this.channelContext.getDecodeRunnable().clearMsgQueue();
                this.channelContext.getHandlerRunnable().clearMsgQueue();
                this.channelContext.getSendRunnable().clearMsgQueue();
                log.info("{} \u51c6\u5907\u5173\u95ed\u8fde\u63a5, isNeedRemove:{}, {}", new Object[]{this.channelContext, isRemove, this.remark});
                try {
                    IpStatType[] ipStatTypes;
                    for (IpStatType v : ipStatTypes = IpStatType.values()) {
                        IpStat ipStat = this.channelContext.getGroupContext().ips.get(v, this.channelContext.getClientNode().getIp());
                        ipStat.getActivatedCount().decrementAndGet();
                    }
                    if (isRemove) {
                        MaintainUtils.removeFromMaintain(this.channelContext);
                    } else {
                        groupContext.closeds.add(this.channelContext);
                        groupContext.connecteds.remove(this.channelContext);
                        if (StringUtils.isNotBlank((CharSequence)this.channelContext.getUserid())) {
                            try {
                                Aio.unbindUser(this.channelContext);
                            }
                            catch (Throwable e) {
                                log.error(e.toString(), e);
                            }
                        }
                        try {
                            Aio.unbindGroup(this.channelContext);
                        }
                        catch (Throwable e) {
                            log.error(e.toString(), e);
                        }
                    }
                    try {
                        this.channelContext.setClosed(true);
                        this.channelContext.setRemoved(isRemove);
                        this.channelContext.getGroupContext().getGroupStat().getClosed().incrementAndGet();
                        this.channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                    }
                    catch (Exception e) {
                        log.error(e.toString(), (Throwable)e);
                    }
                    try {
                        aioListener.onAfterClose(this.channelContext, this.throwable, this.remark, isRemove);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                    if (isRemove) return;
                    if (!this.channelContext.isClosed()) return;
                    if (!isClientChannelContext) return;
                }
                catch (Throwable e) {
                    try {
                        log.error(e.toString(), e);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (!isRemove && this.channelContext.isClosed() && isClientChannelContext) {
                            ClientChannelContext clientChannelContext = (ClientChannelContext)this.channelContext;
                            ReconnConf.put(clientChannelContext);
                        }
                    }
                }
                ClientChannelContext clientChannelContext = (ClientChannelContext)this.channelContext;
                ReconnConf.put(clientChannelContext);
                return;
            }
            catch (Exception e) {
                log.error(this.throwable.toString(), (Throwable)e);
                return;
            }
            finally {
                writeLock.unlock();
            }
        }
        finally {
            this.channelContext.setWaitingClose(false);
        }
    }
}

