/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.cache;

import java.util.Objects;
import org.tio.core.cache.CacheType;
import org.tio.utils.time.Time;

public enum CacheConfig {
    IP_STAT(CacheType.GUAVA, null, Time.DAY_1);

    CacheType cacheType;
    String cacheName;
    Long timeToLiveSeconds;
    Long timeToIdleSeconds;

    public static CacheConfig from(String cacheName) {
        CacheConfig[] values;
        for (CacheConfig v : values = CacheConfig.values()) {
            if (!Objects.equals(v.cacheName, cacheName)) continue;
            return v;
        }
        return null;
    }

    private CacheConfig(CacheType cacheType, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        this.cacheType = cacheType;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.cacheName = this.name();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public Long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public Long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }
}

