/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.cache.CacheConfig;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.guava.GuavaCache;

public class Caches {
    private static Logger log = LoggerFactory.getLogger(Caches.class);

    public static ICache getCache(CacheConfig cacheConfig) {
        String cacheName = cacheConfig.getCacheName();
        GuavaCache ret = null;
        ret = GuavaCache.getCache((String)cacheName);
        if (ret == null) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c", (Object)cacheName);
        }
        return ret;
    }

    private static void init() {
        CacheConfig[] values;
        for (CacheConfig cacheConfig : values = CacheConfig.values()) {
            String cacheName = cacheConfig.getCacheName();
            Long timeToLiveSeconds = cacheConfig.getTimeToLiveSeconds();
            Long timeToIdleSeconds = cacheConfig.getTimeToIdleSeconds();
            GuavaCache.register((String)cacheName, (Long)timeToLiveSeconds, (Long)timeToIdleSeconds);
        }
    }

    public static void main(String[] args) {
    }

    static {
        Caches.init();
    }
}

