/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.utils.lock.MapWithLock;

public class Ids {
    private MapWithLock<String, ChannelContext> map = new MapWithLock(new HashMap());

    public void bind(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        String key = channelContext.getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        Map m = (Map)this.map.getObj();
        try {
            lock.lock();
            m.put(key, channelContext);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext find(GroupContext groupContext, String id) {
        if (groupContext.isShortConnection()) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        String key = id;
        ReentrantReadWriteLock.ReadLock lock = this.map.getLock().readLock();
        Map m = (Map)this.map.getObj();
        try {
            lock.lock();
            ChannelContext channelContext = (ChannelContext)((Object)m.get(key));
            return channelContext;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public MapWithLock<String, ChannelContext> getMap() {
        return this.map;
    }

    public void unbind(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.getGroupContext();
        if (groupContext.isShortConnection()) {
            return;
        }
        String key = channelContext.getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        Map m = (Map)this.map.getObj();
        try {
            lock.lock();
            m.remove(key);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

