/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import com.google.common.cache.RemovalListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.cache.IpStatRemovalListener;
import org.tio.core.stat.IpStat;
import org.tio.core.stat.IpStatType;
import org.tio.utils.cache.guava.GuavaCache;

public class Ips {
    private static Logger log = LoggerFactory.getLogger(Ips.class);
    private static final String CACHE_NAME = "TIO_IP_STAT";
    private String id;
    private GuavaCache[] caches = null;
    private Map<IpStatType, GuavaCache> map = new HashMap<IpStatType, GuavaCache>();

    public Ips(String id) {
        this.id = id;
        String cacheName = CACHE_NAME + this.id;
        IpStatType[] values = IpStatType.values();
        this.caches = new GuavaCache[values.length];
        int i = 0;
        for (IpStatType v : values) {
            GuavaCache guavaCache = GuavaCache.register((String)(cacheName + v.name()), (Long)v.getTimeToLiveSeconds(), null, (RemovalListener)new IpStatRemovalListener());
            this.map.put(v, guavaCache);
            this.caches[i++] = guavaCache;
        }
    }

    public void clear(IpStatType ipStatType) {
        GuavaCache guavaCache = this.map.get((Object)ipStatType);
        guavaCache.clear();
    }

    public IpStat get(IpStatType ipStatType, String ip) {
        return this.get(ipStatType, ip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpStat get(IpStatType ipStatType, String ip, boolean forceCreate) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        GuavaCache guavaCache = this.map.get((Object)ipStatType);
        IpStat ipStat = (IpStat)guavaCache.get(ip);
        if (ipStat == null && forceCreate) {
            Ips ips = this;
            synchronized (ips) {
                ipStat = (IpStat)guavaCache.get(ip);
                if (ipStat == null) {
                    ipStat = new IpStat(ip);
                    guavaCache.put(ip, (Serializable)ipStat);
                }
            }
        }
        return ipStat;
    }

    public ConcurrentMap<String, Serializable> map(IpStatType ipStatType) {
        GuavaCache guavaCache = this.map.get((Object)ipStatType);
        ConcurrentMap map = guavaCache.asMap();
        return map;
    }

    public void setCaches(GuavaCache[] caches) {
        this.caches = caches;
    }

    public long size(IpStatType ipStatType) {
        GuavaCache guavaCache = this.map.get((Object)ipStatType);
        return guavaCache.size();
    }

    public Collection<Serializable> values(IpStatType ipStatType) {
        GuavaCache guavaCache = this.map.get((Object)ipStatType);
        Collection<Serializable> set = guavaCache.asMap().values();
        return set;
    }
}

