/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.stat;

import com.xiaoleilu.hutool.date.BetweenFormater;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.tio.utils.SystemTimer;

public class IpStat
implements Serializable {
    private static final long serialVersionUID = -6942731710053482089L;
    private Date start = new Date();
    private long duration;
    private String ip;
    private AtomicInteger decodeErrorCount = new AtomicInteger();
    private AtomicInteger requestCount = new AtomicInteger();
    private AtomicInteger activatedCount = new AtomicInteger();
    private AtomicLong sentBytes = new AtomicLong();
    private AtomicLong sentPackets = new AtomicLong();
    private AtomicLong handledBytes = new AtomicLong();
    private AtomicLong handledPackets = new AtomicLong();
    private AtomicLong receivedBytes = new AtomicLong();
    private AtomicLong receivedTcps = new AtomicLong();
    private AtomicLong receivedPackets = new AtomicLong();

    public IpStat(String ip) {
        this.ip = ip;
    }

    public double getBytesPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedBytes.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public double getPacketsPerTcpReceive() {
        if (this.receivedTcps.get() == 0L) {
            return 0.0;
        }
        double ret = (double)this.receivedPackets.get() / (double)this.receivedTcps.get();
        return ret;
    }

    public AtomicInteger getDecodeErrorCount() {
        return this.decodeErrorCount;
    }

    public AtomicLong getHandledBytes() {
        return this.handledBytes;
    }

    public AtomicLong getHandledPackets() {
        return this.handledPackets;
    }

    public AtomicLong getReceivedBytes() {
        return this.receivedBytes;
    }

    public AtomicLong getReceivedPackets() {
        return this.receivedPackets;
    }

    public AtomicLong getSentBytes() {
        return this.sentBytes;
    }

    public AtomicLong getSentPackets() {
        return this.sentPackets;
    }

    public void setDecodeErrorCount(AtomicInteger decodeErrorCount) {
        this.decodeErrorCount = decodeErrorCount;
    }

    public void setHandledBytes(AtomicLong countHandledByte) {
        this.handledBytes = countHandledByte;
    }

    public void setHandledPackets(AtomicLong handledPackets) {
        this.handledPackets = handledPackets;
    }

    public void setReceivedBytes(AtomicLong receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public void setReceivedPackets(AtomicLong receivedPackets) {
        this.receivedPackets = receivedPackets;
    }

    public void setSentBytes(AtomicLong sentBytes) {
        this.sentBytes = sentBytes;
    }

    public void setSentPackets(AtomicLong sentPackets) {
        this.sentPackets = sentPackets;
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(AtomicInteger requestCount) {
        this.requestCount = requestCount;
    }

    public AtomicInteger getActivatedCount() {
        return this.activatedCount;
    }

    public void setActivatedCount(AtomicInteger activatedCount) {
        this.activatedCount = activatedCount;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public String getFormatedDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.start.getTime();
        BetweenFormater betweenFormater = new BetweenFormater(this.duration, BetweenFormater.Level.MILLSECOND);
        return betweenFormater.format();
    }

    public long getDuration() {
        this.duration = SystemTimer.currentTimeMillis() - this.start.getTime();
        return this.duration;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public AtomicLong getReceivedTcps() {
        return this.receivedTcps;
    }

    public void setReceivedTcps(AtomicLong receivedTcps) {
        this.receivedTcps = receivedTcps;
    }
}

