/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.format.DatePrinter;
import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.tio.core.Aio;
import org.tio.core.ChannelAction;
import org.tio.core.GroupContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.SynPacketAction;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.ssl.SslUtils;
import org.tio.core.stat.ChannelStat;
import org.tio.core.stat.GroupStat;
import org.tio.core.stat.IpStat;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.task.SendRunnable;
import org.tio.server.ServerGroupContext;
import org.tio.utils.json.Json;
import org.tio.utils.prop.MapWithLockPropSupport;

public abstract class ChannelContext
extends MapWithLockPropSupport {
    private static Logger log = LoggerFactory.getLogger(ChannelContext.class);
    private static final String DEFAULT_ATTUBITE_KEY = "t-io-d-a-k";
    public static final String UNKNOWN_ADDRESS_IP = "$UNKNOWN";
    public static final AtomicInteger UNKNOWN_ADDRESS_PORT_SEQ = new AtomicInteger();
    private boolean isTraceClient = false;
    private boolean isTraceSynPacket = false;
    private boolean isReconnect = false;
    private Integer packetNeededLength = null;
    private GroupContext groupContext = null;
    private DecodeRunnable decodeRunnable = null;
    private HandlerRunnable handlerRunnable = null;
    private SendRunnable sendRunnable = null;
    private ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private ReadCompletionHandler readCompletionHandler = null;
    private WriteCompletionHandler writeCompletionHandler = null;
    private SslFacadeContext sslFacadeContext;
    private int reconnCount = 0;
    private String userid;
    private String token;
    private boolean isWaitingClose = false;
    private boolean isClosed = true;
    private boolean isRemoved = false;
    public final ChannelStat stat = new ChannelStat();
    private AsynchronousSocketChannel asynchronousSocketChannel;
    private String id = null;
    private Node clientNode;
    private String clientNodeTraceFilename;
    private Node serverNode;
    private Logger traceSynPacketLog = LoggerFactory.getLogger((String)"tio-client-trace-syn-log");

    public ChannelContext(GroupContext groupContext, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.init(groupContext, asynchronousSocketChannel);
        if (groupContext.getSslConfig() != null) {
            try {
                SslFacadeContext sslFacadeContext = new SslFacadeContext(this);
                if (groupContext instanceof ServerGroupContext) {
                    sslFacadeContext.beginHandshake();
                }
            }
            catch (Exception e) {
                log.error("\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Aio.close(this, "\u5728\u5f00\u59cbSSL\u63e1\u624b\u65f6\u53d1\u751f\u4e86\u5f02\u5e38" + e.getMessage());
                return;
            }
        }
    }

    private void assignAnUnknownClientNode() {
        Node clientNode = new Node(UNKNOWN_ADDRESS_IP, UNKNOWN_ADDRESS_PORT_SEQ.incrementAndGet());
        this.setClientNode(clientNode);
    }

    public abstract Node createClientNode(AsynchronousSocketChannel var1) throws IOException;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChannelContext other = (ChannelContext)((Object)obj);
        return Objects.equals(other.hashCode(), this.hashCode());
    }

    public AsynchronousSocketChannel getAsynchronousSocketChannel() {
        return this.asynchronousSocketChannel;
    }

    public Object getAttribute() {
        return this.getAttribute(DEFAULT_ATTUBITE_KEY);
    }

    public Node getClientNode() {
        return this.clientNode;
    }

    public String getClientNodeTraceFilename() {
        return this.clientNodeTraceFilename;
    }

    public ReentrantReadWriteLock getCloseLock() {
        return this.closeLock;
    }

    public DecodeRunnable getDecodeRunnable() {
        return this.decodeRunnable;
    }

    public GroupContext getGroupContext() {
        return this.groupContext;
    }

    public HandlerRunnable getHandlerRunnable() {
        return this.handlerRunnable;
    }

    public String getId() {
        return this.id;
    }

    public ReadCompletionHandler getReadCompletionHandler() {
        return this.readCompletionHandler;
    }

    public int getReconnCount() {
        return this.reconnCount;
    }

    public SendRunnable getSendRunnable() {
        return this.sendRunnable;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public String getUserid() {
        return this.userid;
    }

    public WriteCompletionHandler getWriteCompletionHandler() {
        return this.writeCompletionHandler;
    }

    public int hashCode() {
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }

    public void init(GroupContext groupContext, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.id = groupContext.getTioUuid().uuid();
        this.setGroupContext(groupContext);
        groupContext.ids.bind(this);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel);
        this.readCompletionHandler = new ReadCompletionHandler(this);
        this.writeCompletionHandler = new WriteCompletionHandler(this);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isTraceClient() {
        return this.isTraceClient;
    }

    public boolean isTraceSynPacket() {
        return this.isTraceSynPacket;
    }

    public boolean isWaitingClose() {
        return this.isWaitingClose;
    }

    public void processAfterSent(Packet packet, Boolean isSentSuccess) {
        block12: {
            isSentSuccess = isSentSuccess == null ? false : isSentSuccess;
            Packet.Meta meta = packet.getMeta();
            if (meta != null) {
                CountDownLatch countDownLatch = meta.getCountDownLatch();
                this.traceBlockPacket(SynPacketAction.BEFORE_DOWN, packet, countDownLatch, null);
                countDownLatch.countDown();
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("{} \u5df2\u7ecf\u53d1\u9001 {}", (Object)this, (Object)packet.logstr());
                }
                if (this.getSslFacadeContext() != null && !this.getSslFacadeContext().isHandshakeCompleted()) break block12;
                try {
                    this.groupContext.getAioListener().onAfterSent(this, packet, isSentSuccess);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
                GroupStat groupStat = this.groupContext.getGroupStat();
                groupStat.getSentPackets().incrementAndGet();
                this.stat.getSentPackets().incrementAndGet();
                List<Long> list = this.groupContext.ipStats.durationList;
                if (list == null || list.size() <= 0) break block12;
                try {
                    for (Long v : list) {
                        IpStat ipStat = this.groupContext.ipStats.get(v, this.getClientNode().getIp());
                        ipStat.getSentPackets().incrementAndGet();
                        this.groupContext.getIpStatListener().onAfterSent(this, packet, isSentSuccess, ipStat);
                    }
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
        if (packet.getPacketListener() != null) {
            try {
                packet.getPacketListener().onAfterSent(this, packet, isSentSuccess);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    public void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        if (asynchronousSocketChannel != null) {
            try {
                Node clientNode = this.createClientNode(asynchronousSocketChannel);
                this.setClientNode(clientNode);
            }
            catch (IOException e) {
                log.info(e.toString(), (Throwable)e);
                this.assignAnUnknownClientNode();
            }
        } else {
            this.assignAnUnknownClientNode();
        }
    }

    public void setAttribute(Object value) {
        this.setAttribute(DEFAULT_ATTUBITE_KEY, value);
    }

    private void setClientNode(Node clientNode) {
        if (this.clientNode != null) {
            try {
                this.groupContext.clientNodeMap.remove(this);
            }
            catch (Throwable e1) {
                log.error(e1.toString(), e1);
            }
        }
        this.clientNode = clientNode;
        if (this.clientNode != null && !Objects.equals(UNKNOWN_ADDRESS_IP, this.clientNode.getIp())) {
            try {
                this.groupContext.clientNodeMap.put(this);
            }
            catch (Throwable e1) {
                log.error(e1.toString(), e1);
            }
        }
        this.clientNodeTraceFilename = StringUtils.replaceAll((String)clientNode.toString(), (String)":", (String)"_");
    }

    public void setClientNodeTraceFilename(String clientNodeTraceFilename) {
        this.clientNodeTraceFilename = clientNodeTraceFilename;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
        if (isClosed && (this.clientNode == null || !UNKNOWN_ADDRESS_IP.equals(this.clientNode.getIp()))) {
            String before = this.toString();
            this.assignAnUnknownClientNode();
            log.info("\u5173\u95ed\u524d{}, \u5173\u95ed\u540e{}", (Object)before, (Object)this);
        }
    }

    public void setGroupContext(GroupContext groupContext) {
        this.groupContext = groupContext;
        if (groupContext != null) {
            this.decodeRunnable = new DecodeRunnable(this);
            this.handlerRunnable = new HandlerRunnable(this, (Executor)groupContext.getTioExecutor());
            this.sendRunnable = new SendRunnable(this, (Executor)groupContext.getTioExecutor());
            groupContext.connections.add((Object)this);
        }
    }

    public void setReconnCount(int reconnCount) {
        this.reconnCount = reconnCount;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setServerNode(Node serverNode) {
        this.serverNode = serverNode;
    }

    public void setTraceClient(boolean isTraceClient) {
        this.isTraceClient = isTraceClient;
    }

    public void setTraceSynPacket(boolean isTraceSynPacket) {
        this.isTraceSynPacket = isTraceSynPacket;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setWaitingClose(boolean isWaitingClose) {
        this.isWaitingClose = isWaitingClose;
    }

    public String toString() {
        if (SslUtils.isSsl(this)) {
            return this.getClientNode().toString() + ", SslShakehanded:" + this.getSslFacadeContext().isHandshakeCompleted();
        }
        return this.getClientNode().toString();
    }

    public void traceBlockPacket(SynPacketAction synPacketAction, Packet packet, CountDownLatch countDownLatch, Map<String, Object> extmsg) {
        if (this.isTraceSynPacket) {
            ChannelContext channelContext = this;
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            map.put("time", DateTime.now().toString((DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
            map.put("c_id", channelContext.getId());
            map.put("c", channelContext.toString());
            map.put("action", (Object)synPacketAction);
            MDC.put((String)"tio_client_syn", (String)channelContext.getClientNodeTraceFilename());
            if (packet != null) {
                map.put("p_id", channelContext.getClientNode().getPort() + "_" + packet.getId());
                map.put("p_respId", packet.getRespId());
                map.put("packet", packet.logstr());
            }
            if (countDownLatch != null) {
                map.put("countDownLatch", countDownLatch.hashCode() + " " + countDownLatch.getCount());
            }
            if (extmsg != null) {
                map.putAll(extmsg);
            }
            String logstr = Json.toJson(map);
            this.traceSynPacketLog.info(logstr);
            log.error(logstr);
        }
    }

    public void traceClient(ChannelAction channelAction, Packet packet, Map<String, Object> extmsg) {
        if (this.isTraceClient) {
            this.getGroupContext().getClientTraceHandler().traceChannel(this, channelAction, packet, extmsg);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public SslFacadeContext getSslFacadeContext() {
        return this.sslFacadeContext;
    }

    public void setSslFacadeContext(SslFacadeContext sslFacadeContext) {
        this.sslFacadeContext = sslFacadeContext;
    }

    public boolean isReconnect() {
        return this.isReconnect;
    }

    public void setReconnect(boolean isReconnect) {
        this.isReconnect = isReconnect;
    }

    public Integer getPacketNeededLength() {
        return this.packetNeededLength;
    }

    public void setPacketNeededLength(Integer packetNeededLength) {
        this.packetNeededLength = packetNeededLength;
    }
}

