/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.GroupContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.ssl.SslUtils;
import org.tio.core.stat.IpStat;
import org.tio.utils.SystemTimer;

public class ConnectionCompletionHandler
implements CompletionHandler<Void, ConnectionCompletionVo> {
    private static Logger log = LoggerFactory.getLogger(ConnectionCompletionHandler.class);

    @Override
    public void completed(Void result, ConnectionCompletionVo attachment) {
        this.handler(result, attachment, null);
    }

    @Override
    public void failed(Throwable throwable, ConnectionCompletionVo attachment) {
        this.handler(null, attachment, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handler(Void result, ConnectionCompletionVo attachment, Throwable throwable) {
        block40: {
            boolean isConnected;
            boolean isReconnect;
            ClientAioListener clientAioListener;
            ClientChannelContext channelContext;
            block39: {
                channelContext = attachment.getChannelContext();
                AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
                TioClient tioClient = attachment.getTioClient();
                ClientGroupContext clientGroupContext = tioClient.getClientGroupContext();
                Node serverNode = attachment.getServerNode();
                String bindIp = attachment.getBindIp();
                Integer bindPort = attachment.getBindPort();
                clientAioListener = clientGroupContext.getClientAioListener();
                isReconnect = attachment.isReconnect();
                isConnected = false;
                if (throwable == null) {
                    if (isReconnect) {
                        channelContext.setAsynchronousSocketChannel(asynchronousSocketChannel);
                        channelContext.handlerRunnable.setCanceled(false);
                        channelContext.sendRunnable.setCanceled(false);
                        clientGroupContext.closeds.remove((Object)channelContext);
                    } else {
                        channelContext = new ClientChannelContext(clientGroupContext, asynchronousSocketChannel);
                        channelContext.setServerNode(serverNode);
                        channelContext.stat.timeClosed = SystemTimer.currTime;
                    }
                    channelContext.setBindIp(bindIp);
                    channelContext.setBindPort(bindPort);
                    channelContext.setReconnCount(0);
                    channelContext.setClosed(false);
                    isConnected = true;
                    attachment.setChannelContext(channelContext);
                    clientGroupContext.connecteds.add((Object)channelContext);
                    ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                    ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                    readByteBuffer.position(0);
                    readByteBuffer.limit(readByteBuffer.capacity());
                    asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
                    log.info("connected to {}", (Object)serverNode);
                    if (isConnected && !isReconnect) {
                        channelContext.stat.setTimeFirstConnected(SystemTimer.currTime);
                    }
                } else {
                    log.error(throwable.toString(), throwable);
                    if (channelContext == null) {
                        channelContext = new ClientChannelContext(clientGroupContext, asynchronousSocketChannel);
                        channelContext.setServerNode(serverNode);
                        channelContext.stat.setTimeClosed(SystemTimer.currTime);
                    }
                    if (!isReconnect) {
                        clientGroupContext.closeds.add((Object)channelContext);
                    }
                    attachment.setChannelContext(channelContext);
                    ReconnConf.put(channelContext);
                }
                if (attachment.getCountDownLatch() == null) break block39;
                attachment.getCountDownLatch().countDown();
            }
            try {
                channelContext.setReconnect(isReconnect);
                if (SslUtils.isSsl(channelContext.groupContext)) {
                    if (isConnected) {
                        SslFacadeContext sslFacadeContext = new SslFacadeContext(channelContext);
                        sslFacadeContext.beginHandshake();
                    } else {
                        clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                    }
                } else {
                    clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                }
                GroupContext groupContext = channelContext.groupContext;
                if (groupContext.ipStats.durationList == null || groupContext.ipStats.durationList.size() <= 0) break block40;
                try {
                    for (Long v : groupContext.ipStats.durationList) {
                        IpStat ipStat = groupContext.ipStats.get(v, channelContext.getClientNode().getIp());
                        ipStat.getRequestCount().incrementAndGet();
                        groupContext.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                    }
                    break block40;
                }
                catch (Exception e2) {
                    log.error(e2.toString(), (Throwable)e2);
                }
            }
            catch (Throwable e1) {
                log.error(e1.toString(), e1);
            }
            break block40;
            catch (Throwable e) {
                block41: {
                    log.error(e.toString(), e);
                    if (attachment.getCountDownLatch() == null) break block41;
                    attachment.getCountDownLatch().countDown();
                }
                try {
                    channelContext.setReconnect(isReconnect);
                    if (SslUtils.isSsl(channelContext.groupContext)) {
                        if (isConnected) {
                            SslFacadeContext sslFacadeContext = new SslFacadeContext(channelContext);
                            sslFacadeContext.beginHandshake();
                        } else {
                            clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                        }
                    } else {
                        clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                    }
                    GroupContext groupContext = channelContext.groupContext;
                    if (groupContext.ipStats.durationList == null || groupContext.ipStats.durationList.size() <= 0) break block40;
                    try {
                        for (Long v : groupContext.ipStats.durationList) {
                            IpStat ipStat = groupContext.ipStats.get(v, channelContext.getClientNode().getIp());
                            ipStat.getRequestCount().incrementAndGet();
                            groupContext.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                        }
                    }
                    catch (Exception e2) {
                        log.error(e2.toString(), (Throwable)e2);
                    }
                }
                catch (Throwable e1) {
                    log.error(e1.toString(), e1);
                }
                catch (Throwable throwable2) {
                    block42: {
                        if (attachment.getCountDownLatch() != null) {
                            attachment.getCountDownLatch().countDown();
                        }
                        try {
                            channelContext.setReconnect(isReconnect);
                            if (SslUtils.isSsl(channelContext.groupContext)) {
                                if (isConnected) {
                                    SslFacadeContext sslFacadeContext = new SslFacadeContext(channelContext);
                                    sslFacadeContext.beginHandshake();
                                } else {
                                    clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                                }
                            } else {
                                clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
                            }
                            GroupContext groupContext = channelContext.groupContext;
                            if (groupContext.ipStats.durationList == null || groupContext.ipStats.durationList.size() <= 0) break block42;
                            try {
                                for (Long v : groupContext.ipStats.durationList) {
                                    IpStat ipStat = groupContext.ipStats.get(v, channelContext.getClientNode().getIp());
                                    ipStat.getRequestCount().incrementAndGet();
                                    groupContext.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                                }
                            }
                            catch (Exception e3) {
                                log.error(e3.toString(), (Throwable)e3);
                            }
                        }
                        catch (Throwable e1) {
                            log.error(e1.toString(), e1);
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }
}

