/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.DefaultTioUuid;
import org.tio.core.PacketHandlerMode;
import org.tio.core.cluster.DefaultMessageListener;
import org.tio.core.cluster.TioClusterConfig;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.Packet;
import org.tio.core.intf.TioUuid;
import org.tio.core.maintain.BsIds;
import org.tio.core.maintain.ClientNodeMap;
import org.tio.core.maintain.Groups;
import org.tio.core.maintain.Ids;
import org.tio.core.maintain.IpBlacklist;
import org.tio.core.maintain.IpStats;
import org.tio.core.maintain.Ips;
import org.tio.core.maintain.Tokens;
import org.tio.core.maintain.Users;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.DefaultIpStatListener;
import org.tio.core.stat.GroupStat;
import org.tio.core.stat.IpStatListener;
import org.tio.core.task.CloseRunnable;
import org.tio.utils.Threads;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.prop.MapWithLockPropSupport;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public abstract class GroupContext
extends MapWithLockPropSupport {
    static Logger log = LoggerFactory.getLogger(GroupContext.class);
    public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 2048);
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    public boolean isShortConnection = false;
    public SslConfig sslConfig = null;
    public boolean debug = false;
    public GroupStat groupStat = null;
    public boolean useQueueSend = true;
    public boolean useQueueDecode = false;
    public long heartbeatTimeout = 120000L;
    public PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;
    public int readBufferSize = READ_BUFFER_SIZE;
    private GroupListener groupListener = null;
    private TioUuid tioUuid = new DefaultTioUuid();
    public SynThreadPoolExecutor tioExecutor = null;
    public CloseRunnable closeRunnable;
    public ThreadPoolExecutor groupExecutor = null;
    public final ClientNodeMap clientNodeMap = new ClientNodeMap();
    public final SetWithLock<ChannelContext> connections = new SetWithLock(new HashSet());
    public final Groups groups = new Groups();
    public final Users users = new Users();
    public final Tokens tokens = new Tokens();
    public final Ids ids = new Ids();
    public final BsIds bsIds = new BsIds();
    public final Ips ips = new Ips();
    public IpStats ipStats = null;
    public IpBlacklist ipBlacklist = null;
    public final MapWithLock<Integer, Packet> waitingResps = new MapWithLock(new HashMap());
    protected String id;
    protected int maxDecodeErrorCountForIp = 10;
    protected String name = "\u672a\u547d\u540dGroupContext";
    private IpStatListener ipStatListener = DefaultIpStatListener.me;
    private boolean isStopped = false;
    private TioClusterConfig tioClusterConfig = null;

    public GroupContext() {
        this(null, null);
    }

    public GroupContext(SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this(null, tioExecutor, groupExecutor);
    }

    public GroupContext(TioClusterConfig tioClusterConfig, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.id = ID_ATOMIC.incrementAndGet() + "";
        this.ipBlacklist = new IpBlacklist(this.id, this);
        this.ipStats = new IpStats(this, null);
        this.setTioClusterConfig(tioClusterConfig);
        this.tioExecutor = tioExecutor;
        if (this.tioExecutor == null) {
            this.tioExecutor = Threads.tioExecutor;
        }
        this.groupExecutor = groupExecutor;
        if (this.groupExecutor == null) {
            this.groupExecutor = Threads.groupExecutor;
        }
        this.closeRunnable = new CloseRunnable((Executor)this.tioExecutor);
    }

    public abstract AioHandler getAioHandler();

    public abstract AioListener getAioListener();

    public boolean isCluster() {
        return this.tioClusterConfig != null;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public GroupListener getGroupListener() {
        return this.groupListener;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TioUuid getTioUuid() {
        return this.tioUuid;
    }

    public MapWithLock<Integer, Packet> getWaitingResps() {
        return this.waitingResps;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setGroupListener(GroupListener groupListener) {
        this.groupListener = groupListener;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
        this.packetHandlerMode = packetHandlerMode;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = Math.min(readBufferSize, 51200);
    }

    public void setShortConnection(boolean isShortConnection) {
        this.isShortConnection = isShortConnection;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void setTioUuid(TioUuid tioUuid) {
        this.tioUuid = tioUuid;
    }

    public TioClusterConfig getTioClusterConfig() {
        return this.tioClusterConfig;
    }

    public void setTioClusterConfig(TioClusterConfig tioClusterConfig) {
        this.tioClusterConfig = tioClusterConfig;
        if (this.tioClusterConfig != null) {
            this.tioClusterConfig.addMessageListener(new DefaultMessageListener(this));
        }
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public IpStatListener getIpStatListener() {
        return this.ipStatListener;
    }

    public void setIpStatListener(IpStatListener ipStatListener) {
        this.ipStatListener = ipStatListener;
    }

    public GroupStat getGroupStat() {
        return this.groupStat;
    }

    public void setUseQueueDecode(boolean useQueueDecode) {
        this.useQueueDecode = useQueueDecode;
    }

    public void setUseQueueSend(boolean useQueueSend) {
        this.useQueueSend = useQueueSend;
    }

    public abstract boolean isServer();
}

