/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.stat.IpStat;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.utils.SystemTimer;

public class ReadCompletionHandler
implements CompletionHandler<Integer, ByteBuffer> {
    private static Logger log = LoggerFactory.getLogger(ReadCompletionHandler.class);
    private ChannelContext channelContext = null;
    private ByteBuffer readByteBuffer;

    public ReadCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.readByteBuffer = ByteBuffer.allocate(channelContext.groupContext.readBufferSize);
    }

    @Override
    public void completed(Integer result, ByteBuffer byteBuffer) {
        if (result > 0) {
            ByteBuffer copiedByteBuffer;
            GroupContext groupContext = this.channelContext.groupContext;
            groupContext.groupStat.receivedBytes.addAndGet(result.intValue());
            groupContext.groupStat.receivedTcps.incrementAndGet();
            this.channelContext.stat.receivedBytes.addAndGet(result.intValue());
            this.channelContext.stat.receivedTcps.incrementAndGet();
            this.channelContext.stat.latestTimeOfReceivedByte = SystemTimer.currTime;
            if (groupContext.ipStats.durationList != null && groupContext.ipStats.durationList.size() > 0) {
                try {
                    for (Long v : groupContext.ipStats.durationList) {
                        IpStat ipStat = groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                        ipStat.getReceivedBytes().addAndGet(result.intValue());
                        ipStat.getReceivedTcps().incrementAndGet();
                        groupContext.getIpStatListener().onAfterReceivedBytes(this.channelContext, result, ipStat);
                    }
                }
                catch (Exception e1) {
                    log.error(this.channelContext.toString(), (Throwable)e1);
                }
            }
            try {
                groupContext.getAioListener().onAfterReceivedBytes(this.channelContext, result);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            this.readByteBuffer.flip();
            if (this.channelContext.sslFacadeContext == null) {
                if (groupContext.useQueueDecode) {
                    copiedByteBuffer = ByteBufferUtils.copy(this.readByteBuffer);
                    this.channelContext.decodeRunnable.addMsg(copiedByteBuffer);
                    this.channelContext.decodeRunnable.execute();
                } else {
                    this.channelContext.decodeRunnable.setNewByteBuffer(this.readByteBuffer);
                    this.channelContext.decodeRunnable.decode();
                }
            } else {
                copiedByteBuffer = null;
                try {
                    copiedByteBuffer = ByteBufferUtils.copy(this.readByteBuffer);
                    log.debug("{}, \u4e22\u7ed9SslFacade\u89e3\u5bc6:{}", (Object)this.channelContext, (Object)copiedByteBuffer);
                    this.channelContext.sslFacadeContext.getSslFacade().decrypt(copiedByteBuffer);
                }
                catch (Exception e) {
                    log.error((Object)((Object)this.channelContext) + ", " + e.toString() + copiedByteBuffer, (Throwable)e);
                    Tio.close(this.channelContext, e, e.toString());
                }
            }
        } else {
            if (result == 0) {
                log.error("{}, \u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a0", (Object)this.channelContext);
                Tio.close(this.channelContext, null, "\u8bfb\u5230\u7684\u6570\u636e\u957f\u5ea6\u4e3a0");
                return;
            }
            if (result < 0) {
                if (result == -1) {
                    Tio.close(this.channelContext, null, "\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5");
                    return;
                }
                Tio.close(this.channelContext, null, "\u8bfb\u6570\u636e\u65f6\u8fd4\u56de" + result);
                return;
            }
        }
        this.readByteBuffer.position(0);
        this.readByteBuffer.limit(this.readByteBuffer.capacity());
        this.channelContext.asynchronousSocketChannel.read(this.readByteBuffer, this.readByteBuffer, this);
    }

    @Override
    public void failed(Throwable exc, ByteBuffer byteBuffer) {
        Tio.close(this.channelContext, exc, "\u8bfb\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38");
    }

    public ByteBuffer getReadByteBuffer() {
        return this.readByteBuffer;
    }
}

