/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.core.stat.IpStat;
import org.tio.utils.SystemTimer;

public class WriteCompletionHandler
implements CompletionHandler<Integer, WriteCompletionVo> {
    private static Logger log = LoggerFactory.getLogger(WriteCompletionHandler.class);
    private ChannelContext channelContext = null;
    private Semaphore writeSemaphore = new Semaphore(1);

    public WriteCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void completed(Integer result, WriteCompletionVo writeCompletionVo) {
        ByteBuffer byteBuffer = writeCompletionVo.byteBuffer;
        if (byteBuffer.hasRemaining()) {
            log.info("{} {}/{} has sent", new Object[]{this.channelContext, byteBuffer.position(), byteBuffer.capacity()});
            this.channelContext.asynchronousSocketChannel.write(byteBuffer, writeCompletionVo, this);
            this.channelContext.stat.latestTimeOfSentByte = SystemTimer.currTime;
        } else {
            this.channelContext.stat.latestTimeOfSentPacket = SystemTimer.currTime;
            this.handle(result, null, writeCompletionVo);
        }
    }

    @Override
    public void failed(Throwable throwable, WriteCompletionVo writeCompletionVo) {
        this.handle(0, throwable, writeCompletionVo);
    }

    public Semaphore getWriteSemaphore() {
        return this.writeSemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Integer result, Throwable throwable, WriteCompletionVo writeCompletionVo) {
        boolean isSentSuccess;
        this.writeSemaphore.release();
        Object attachment = writeCompletionVo.obj;
        GroupContext groupContext = this.channelContext.groupContext;
        boolean bl = isSentSuccess = result > 0;
        if (isSentSuccess) {
            groupContext.groupStat.sentBytes.addAndGet(result.intValue());
            this.channelContext.stat.sentBytes.addAndGet(result.intValue());
            if (groupContext.ipStats.durationList != null && groupContext.ipStats.durationList.size() > 0) {
                for (Long l : groupContext.ipStats.durationList) {
                    IpStat ipStat = this.channelContext.groupContext.ipStats.get(l, this.channelContext.getClientNode().getIp());
                    ipStat.getSentBytes().addAndGet(result.intValue());
                }
            }
        }
        try {
            boolean isPacket = attachment instanceof Packet;
            if (isPacket) {
                if (isSentSuccess && groupContext.ipStats.durationList != null && groupContext.ipStats.durationList.size() > 0) {
                    for (Long v : groupContext.ipStats.durationList) {
                        IpStat ipStat = this.channelContext.groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                        ipStat.getSentPackets().incrementAndGet();
                    }
                }
                this.handleOne(result, throwable, (Packet)attachment, isSentSuccess);
            } else {
                List list = (List)attachment;
                for (Object obj : list) {
                    this.handleOne(result, throwable, (Packet)obj, isSentSuccess);
                }
            }
            if (!isSentSuccess) {
                Tio.close(this.channelContext, throwable, "\u5199\u6570\u636e\u8fd4\u56de:" + result);
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    public void handleOne(Integer result, Throwable throwable, Packet packet, Boolean isSentSuccess) {
        Packet.Meta meta = packet.getMeta();
        if (meta != null) {
            meta.setIsSentSuccess(isSentSuccess);
        }
        try {
            this.channelContext.processAfterSent(packet, isSentSuccess);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    public static class WriteCompletionVo {
        private ByteBuffer byteBuffer = null;
        private Object obj = null;

        public WriteCompletionVo(ByteBuffer byteBuffer, Object obj) {
            this.byteBuffer = byteBuffer;
            this.obj = obj;
        }
    }
}

