/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.cluster;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.cluster.TioClusterVo;
import org.tio.core.intf.Packet;
import org.tio.utils.json.Json;

public class DefaultMessageListener
implements MessageListener<TioClusterVo> {
    private static Logger log = LoggerFactory.getLogger(DefaultMessageListener.class);
    private static final AtomicLong RECEIVED_TOPIC_COUNT = new AtomicLong();
    private GroupContext groupContext;

    public DefaultMessageListener(GroupContext groupContext) {
        this.groupContext = groupContext;
    }

    public void onMessage(String channel, TioClusterVo tioClusterVo) {
        String channelId;
        String ip;
        String token;
        String userid;
        String group;
        log.info("\u6536\u5230topic:{}, count:{}, tioClusterVo:{}", new Object[]{channel, RECEIVED_TOPIC_COUNT.incrementAndGet(), Json.toJson((Object)tioClusterVo)});
        String clientid = tioClusterVo.getClientId();
        if (StringUtils.isBlank((CharSequence)clientid)) {
            log.error("clientid is null");
            return;
        }
        if (Objects.equals(TioClusterVo.CLIENTID, clientid)) {
            log.info("\u81ea\u5df1\u53d1\u5e03\u7684\u6d88\u606f\uff0c\u5ffd\u7565\u6389,{}", (Object)clientid);
            return;
        }
        Packet packet = tioClusterVo.getPacket();
        if (packet == null) {
            log.error("packet is null");
            return;
        }
        packet.setFromCluster(true);
        boolean isToAll = tioClusterVo.isToAll();
        if (isToAll) {
            Tio.sendToAll(this.groupContext, packet);
        }
        if (StringUtils.isNotBlank((CharSequence)(group = tioClusterVo.getGroup()))) {
            Tio.sendToGroup(this.groupContext, group, packet);
        }
        if (StringUtils.isNotBlank((CharSequence)(userid = tioClusterVo.getUserid()))) {
            Tio.sendToUser(this.groupContext, userid, packet);
        }
        if (StringUtils.isNotBlank((CharSequence)(token = tioClusterVo.getToken()))) {
            Tio.sendToToken(this.groupContext, token, packet);
        }
        if (StringUtils.isNotBlank((CharSequence)(ip = tioClusterVo.getIp()))) {
            Tio.sendToIp(this.groupContext, ip, packet);
        }
        if (StringUtils.isNotBlank((CharSequence)(channelId = tioClusterVo.getChannelId()))) {
            Tio.sendToId(this.groupContext, channelId, packet);
        }
    }
}

