/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.cluster;

import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.tio.core.cluster.TioClusterVo;

public class TioClusterConfig {
    public static final String TIO_CLUSTER_TOPIC = "TIOCORE_CLUSTER";
    private String topicSuffix;
    private String topic;
    private RedissonClient redisson;
    public RTopic<TioClusterVo> rtopic;
    private boolean cluster4group = false;
    private boolean cluster4user = true;
    private boolean cluster4ip = true;
    private boolean cluster4channelId = true;
    private boolean cluster4all = true;

    private TioClusterConfig(String topicSuffix, RedissonClient redisson) {
        this.setTopicSuffix(topicSuffix);
        this.setRedisson(redisson);
    }

    public static TioClusterConfig newInstance(String topicSuffix, RedissonClient redisson) {
        if (redisson == null) {
            throw new IllegalArgumentException(RedissonClient.class.getSimpleName() + "\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        TioClusterConfig me = new TioClusterConfig(topicSuffix, redisson);
        me.rtopic = redisson.getTopic(me.topic);
        return me;
    }

    public void publishAsyn(TioClusterVo tioClusterVo) {
        this.rtopic.publishAsync((Object)tioClusterVo);
    }

    public void publish(TioClusterVo tioClusterVo) {
        this.rtopic.publish((Object)tioClusterVo);
    }

    public void addMessageListener(MessageListener<TioClusterVo> listener) {
        this.rtopic.addListener(listener);
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public void setRedisson(RedissonClient redisson) {
        this.redisson = redisson;
    }

    public boolean isCluster4group() {
        return this.cluster4group;
    }

    public void setCluster4group(boolean cluster4group) {
        this.cluster4group = cluster4group;
    }

    public boolean isCluster4user() {
        return this.cluster4user;
    }

    public void setCluster4user(boolean cluster4user) {
        this.cluster4user = cluster4user;
    }

    public boolean isCluster4ip() {
        return this.cluster4ip;
    }

    public void setCluster4ip(boolean cluster4ip) {
        this.cluster4ip = cluster4ip;
    }

    public boolean isCluster4all() {
        return this.cluster4all;
    }

    public void setCluster4all(boolean cluster4all) {
        this.cluster4all = cluster4all;
    }

    public String getTopicSuffix() {
        return this.topicSuffix;
    }

    public void setTopicSuffix(String topicSuffix) {
        this.topicSuffix = topicSuffix;
        this.topic = topicSuffix + TIO_CLUSTER_TOPIC;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isCluster4channelId() {
        return this.cluster4channelId;
    }

    public void setCluster4channelId(boolean cluster4channelId) {
        this.cluster4channelId = cluster4channelId;
    }
}

