/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.utils.lock.ObjWithLock;

public class ClientNodeMap {
    private static Logger log = LoggerFactory.getLogger(ClientNodeMap.class);
    private ObjWithLock<DualHashBidiMap<String, ChannelContext>> objWithLock = new ObjWithLock((Object)new DualHashBidiMap());

    public static String getKey(ChannelContext channelContext) {
        Node clientNode = channelContext.getClientNode();
        if (clientNode == null) {
            throw new RuntimeException("client node is null");
        }
        String key = ClientNodeMap.getKey(clientNode.getIp(), clientNode.getPort());
        return key;
    }

    public static String getKey(String ip, int port) {
        String key = ip + ":" + port;
        return key;
    }

    public ChannelContext find(String key) {
        ReentrantReadWriteLock.ReadLock lock = this.objWithLock.readLock();
        lock.lock();
        try {
            DualHashBidiMap m = (DualHashBidiMap)this.objWithLock.getObj();
            ChannelContext channelContext = (ChannelContext)((Object)m.get((Object)key));
            return channelContext;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext find(String ip, int port) {
        String key = ClientNodeMap.getKey(ip, port);
        return this.find(key);
    }

    public ObjWithLock<DualHashBidiMap<String, ChannelContext>> getObjWithLock() {
        return this.objWithLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ChannelContext channelContext) {
        try {
            if (channelContext.groupContext.isShortConnection) {
                return;
            }
            ReentrantReadWriteLock.WriteLock lock = this.objWithLock.writeLock();
            lock.lock();
            try {
                String key = ClientNodeMap.getKey(channelContext);
                DualHashBidiMap m = (DualHashBidiMap)this.objWithLock.getObj();
                m.put((Object)key, (Object)channelContext);
            }
            catch (Throwable e) {
                log.error("", e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void remove(ChannelContext channelContext) {
        try {
            if (channelContext.groupContext.isShortConnection) {
                return;
            }
            ReentrantReadWriteLock.WriteLock lock = this.objWithLock.writeLock();
            lock.lock();
            try {
                DualHashBidiMap m = (DualHashBidiMap)this.objWithLock.getObj();
                m.removeValue((Object)channelContext);
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }
}

