/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.GroupListener;
import org.tio.core.maintain.MaintainUtils;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.SetWithLock;

public class Groups {
    private Comparator<ChannelContext> channelContextComparator = null;
    private static Logger log = LoggerFactory.getLogger(Groups.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> groupmap = new MapWithLock(new HashMap());

    public void bind(String groupid, ChannelContext channelContext) {
        this.bind(groupid, channelContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String groupid, ChannelContext channelContext, boolean callbackListener) {
        try {
            GroupContext groupContext = channelContext.groupContext;
            if (groupContext.isShortConnection) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)groupid)) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)groupid)) {
                return;
            }
            SetWithLock channelContexts = null;
            ReentrantReadWriteLock.WriteLock lock1 = this.groupmap.writeLock();
            lock1.lock();
            try {
                GroupListener groupListener;
                SetWithLock set;
                Map map = (Map)this.groupmap.getObj();
                channelContexts = (SetWithLock)map.get(groupid);
                if (channelContexts == null) {
                    channelContexts = new SetWithLock(MaintainUtils.createSet(this.channelContextComparator));
                    map.put(groupid, channelContexts);
                }
                if ((set = channelContext.getGroups()) == null) {
                    set = new SetWithLock(new HashSet());
                    channelContext.setGroups((SetWithLock<String>)set);
                }
                set.add((Object)groupid);
                channelContexts.add((Object)channelContext);
                if (callbackListener && (groupListener = groupContext.getGroupListener()) != null) {
                    try {
                        groupListener.onAfterBind(channelContext, groupid);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                lock1.unlock();
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public SetWithLock<ChannelContext> clients(GroupContext groupContext, String groupid) {
        if (groupContext.isShortConnection) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)groupid)) {
            return null;
        }
        return (SetWithLock)this.groupmap.get((Object)groupid);
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getGroupmap() {
        return this.groupmap;
    }

    public SetWithLock<String> groups(ChannelContext channelContext) {
        GroupContext groupContext = channelContext.groupContext;
        if (groupContext.isShortConnection) {
            return null;
        }
        return channelContext.getGroups();
    }

    public void unbind(ChannelContext channelContext) {
        this.unbind(channelContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(ChannelContext channelContext, boolean callbackListener) {
        block14: {
            try {
                GroupContext groupContext = channelContext.groupContext;
                if (groupContext.isShortConnection) {
                    return;
                }
                SetWithLock<String> setWithLock = channelContext.getGroups();
                if (setWithLock == null) break block14;
                ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
                writeLock.lock();
                try {
                    Set groups = (Set)setWithLock.getObj();
                    if (groups != null && groups.size() > 0) {
                        for (String groupid : groups) {
                            try {
                                this.unbind(groupid, channelContext, false, callbackListener);
                            }
                            catch (Exception e) {
                                log.error(e.toString(), (Throwable)e);
                            }
                        }
                        groups.clear();
                        channelContext.setGroups(null);
                    }
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
                finally {
                    writeLock.unlock();
                }
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    public void unbind(String groupid, ChannelContext channelContext) {
        this.unbind(groupid, channelContext, true);
    }

    public void unbind(String groupid, ChannelContext channelContext, boolean deleteFromChannelContext) {
        this.unbind(groupid, channelContext, deleteFromChannelContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String groupid, ChannelContext channelContext, boolean deleteFromChannelContext, boolean callbackListener) {
        block15: {
            try {
                GroupListener groupListener;
                SetWithLock<String> setInChannelContext;
                GroupContext groupContext = channelContext.groupContext;
                if (groupContext.isShortConnection) {
                    return;
                }
                if (StringUtils.isBlank((CharSequence)groupid)) {
                    return;
                }
                SetWithLock setWithLock = (SetWithLock)((Map)this.groupmap.getObj()).get(groupid);
                if (setWithLock == null) break block15;
                boolean ss = setWithLock.remove((Object)channelContext);
                if (!ss) {
                    log.error("{}, \u79fb\u9664\u5931\u8d25", (Object)channelContext);
                }
                if (deleteFromChannelContext && (setInChannelContext = channelContext.getGroups()) != null) {
                    setInChannelContext.remove((Object)groupid);
                }
                if (callbackListener && (groupListener = groupContext.getGroupListener()) != null) {
                    try {
                        groupListener.onAfterUnbind(channelContext, groupid);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                if (((Set)setWithLock.getObj()).size() != 0) break block15;
                ReentrantReadWriteLock.WriteLock lock2 = this.groupmap.writeLock();
                lock2.lock();
                try {
                    if (((Set)setWithLock.getObj()).size() == 0) {
                        ((Map)this.groupmap.getObj()).remove(groupid);
                    }
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
                finally {
                    lock2.unlock();
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public Comparator<ChannelContext> getChannelContextComparator() {
        return this.channelContextComparator;
    }

    public void setChannelContextComparator(Comparator<ChannelContext> channelContextComparator) {
        this.channelContextComparator = channelContextComparator;
    }
}

