/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import com.github.benmanes.caffeine.cache.RemovalListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.GroupContext;
import org.tio.core.cache.IpStatRemovalListener;
import org.tio.core.stat.IpStat;
import org.tio.utils.cache.caffeine.CaffeineCache;

public class IpStats {
    private static Logger log = LoggerFactory.getLogger(IpStats.class);
    private static final String CACHE_NAME = "TIO_IP_STAT";
    private String groupContextId;
    private GroupContext groupContext;
    public final Map<Long, CaffeineCache> cacheMap = new HashMap<Long, CaffeineCache>();
    public List<Long> durationList = null;

    public IpStats(GroupContext groupContext, Long[] durations) {
        this.groupContext = groupContext;
        this.groupContextId = groupContext.getId();
        if (durations != null) {
            this.addDurations(durations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDuration(Long duration) {
        IpStats ipStats = this;
        synchronized (ipStats) {
            if (this.durationList == null) {
                this.durationList = new ArrayList<Long>();
            }
            CaffeineCache caffeineCache = CaffeineCache.register((String)this.getCacheName(duration), (Long)duration, null, (RemovalListener)new IpStatRemovalListener(this.groupContext, this.groupContext.getIpStatListener()));
            this.cacheMap.put(duration, caffeineCache);
            this.durationList.add(duration);
        }
    }

    public void addDurations(Long[] durations) {
        if (durations != null) {
            for (Long duration : durations) {
                this.addDuration(duration);
            }
        }
    }

    public void removeDuration(Long duration) {
        this.clear(duration);
        this.cacheMap.remove(duration);
        if (this.durationList != null) {
            this.durationList.remove(duration);
        }
    }

    public String getCacheName(Long duration) {
        String cacheName = "TIO_IP_STAT_" + this.groupContextId + "_";
        return cacheName + duration;
    }

    public void clear(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return;
        }
        caffeineCache.clear();
    }

    public IpStat get(Long duration, String ip) {
        return this.get(duration, ip, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpStat get(Long duration, String ip, boolean forceCreate) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        IpStat ipStat = (IpStat)caffeineCache.get(ip);
        if (ipStat == null && forceCreate) {
            IpStats ipStats = this;
            synchronized (ipStats) {
                ipStat = (IpStat)caffeineCache.get(ip);
                if (ipStat == null) {
                    ipStat = new IpStat(ip, duration);
                    caffeineCache.put(ip, (Serializable)ipStat);
                }
            }
        }
        return ipStat;
    }

    public ConcurrentMap<String, Serializable> map(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        ConcurrentMap map = caffeineCache.asMap();
        return map;
    }

    public Long size(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        return caffeineCache.size();
    }

    public Collection<Serializable> values(Long duration) {
        CaffeineCache caffeineCache = this.cacheMap.get(duration);
        if (caffeineCache == null) {
            return null;
        }
        Collection<Serializable> set = caffeineCache.asMap().values();
        return set;
    }
}

