/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ssl.SslHandshakeCompletedListener;
import org.tio.core.ssl.SslListener;
import org.tio.core.ssl.SslSessionClosedListener;
import org.tio.core.ssl.facade.DefaultTaskHandler;
import org.tio.core.ssl.facade.ISSLFacade;
import org.tio.core.ssl.facade.SSLFacade;

public class SslFacadeContext {
    private static Logger log = LoggerFactory.getLogger(SslFacadeContext.class);
    private ChannelContext channelContext = null;
    private SSLContext sslContext;
    private ISSLFacade sslFacade = null;
    private boolean isHandshakeCompleted = false;

    public SslFacadeContext(ChannelContext channelContext) throws Exception {
        this.channelContext = channelContext;
        this.channelContext.setSslFacadeContext(this);
        this.isHandshakeCompleted = false;
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(channelContext.groupContext.sslConfig.getKeyManagerFactory().getKeyManagers(), channelContext.groupContext.sslConfig.getTrustManagerFactory().getTrustManagers(), null);
        DefaultTaskHandler taskHandler = new DefaultTaskHandler();
        boolean isClient = true;
        if (this.channelContext.isServer()) {
            isClient = false;
        }
        this.sslFacade = new SSLFacade(this.channelContext, this.sslContext, isClient, false, taskHandler);
        this.sslFacade.setHandshakeCompletedListener(new SslHandshakeCompletedListener(this.channelContext));
        this.sslFacade.setSSLListener(new SslListener(this.channelContext));
        this.sslFacade.setCloseListener(new SslSessionClosedListener(this.channelContext));
    }

    public void beginHandshake() throws Exception {
        log.info("{} \u5f00\u59cbSSL\u63e1\u624b", (Object)this.channelContext);
        this.sslFacade.beginHandshake();
    }

    public static void main(String[] args) {
    }

    public boolean isHandshakeCompleted() {
        return this.isHandshakeCompleted;
    }

    public void setHandshakeCompleted(boolean isHandshakeCompleted) {
        this.isHandshakeCompleted = isHandshakeCompleted;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ISSLFacade getSslFacade() {
        return this.sslFacade;
    }
}

