/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.facade.IHandshakeCompletedListener;

public class SslHandshakeCompletedListener
implements IHandshakeCompletedListener {
    private static Logger log = LoggerFactory.getLogger(SslHandshakeCompletedListener.class);
    private ChannelContext channelContext;

    public SslHandshakeCompletedListener(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    public static void main(String[] args) {
    }

    @Override
    public void onComplete() {
        Packet packet;
        log.info("{}, \u5b8c\u6210SSL\u63e1\u624b", (Object)this.channelContext);
        this.channelContext.sslFacadeContext.setHandshakeCompleted(true);
        try {
            this.channelContext.groupContext.getAioListener().onAfterConnected(this.channelContext, true, this.channelContext.isReconnect);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        ConcurrentLinkedQueue<Packet> forSendAfterSslHandshakeCompleted = this.channelContext.sendRunnable.getForSendAfterSslHandshakeCompleted(false);
        if (forSendAfterSslHandshakeCompleted == null || forSendAfterSslHandshakeCompleted.size() == 0) {
            return;
        }
        log.info("{} \u4e1a\u52a1\u5c42\u5728SSL\u63e1\u624b\u524d\u5c31\u6709{}\u6761\u6570\u636e\u5f85\u53d1\u9001", (Object)this.channelContext, (Object)forSendAfterSslHandshakeCompleted.size());
        while ((packet = forSendAfterSslHandshakeCompleted.poll()) != null) {
            if (this.channelContext.groupContext.useQueueSend) {
                this.channelContext.sendRunnable.addMsg(packet);
                continue;
            }
            this.channelContext.sendRunnable.sendPacket(packet);
        }
        if (this.channelContext.groupContext.useQueueSend) {
            this.channelContext.groupContext.tioExecutor.execute((Runnable)((Object)this.channelContext.sendRunnable));
        }
    }
}

