/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.core.stat.IpStat;
import org.tio.utils.SystemTimer;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class HandlerRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(HandlerRunnable.class);
    private ChannelContext channelContext = null;
    private GroupContext groupContext = null;
    private AtomicLong synFailCount = new AtomicLong();

    public HandlerRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.groupContext = channelContext.groupContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handler(Packet packet) {
        block24: {
            long start = SystemTimer.currTime;
            try {
                Integer synSeq = packet.getSynSeq();
                if (synSeq != null && synSeq > 0) {
                    MapWithLock<Integer, Packet> syns = this.groupContext.getWaitingResps();
                    Packet initPacket = (Packet)syns.remove((Object)synSeq);
                    if (initPacket != null) {
                        Packet packet2 = initPacket;
                        synchronized (packet2) {
                            syns.put((Object)synSeq, (Object)packet);
                            initPacket.notify();
                            break block24;
                        }
                    }
                    log.error("[{}]\u540c\u6b65\u6d88\u606f\u5931\u8d25, synSeq is {}, \u4f46\u662f\u540c\u6b65\u96c6\u5408\u4e2d\u6ca1\u6709\u5bf9\u5e94key\u503c", (Object)this.synFailCount.incrementAndGet(), (Object)synSeq);
                    break block24;
                }
                this.groupContext.getAioHandler().handler(packet, this.channelContext);
            }
            catch (Throwable e) {
                log.error(packet.logstr(), e);
            }
            finally {
                long end = SystemTimer.currTime;
                long iv = end - start;
                this.channelContext.stat.handledPackets.incrementAndGet();
                this.channelContext.stat.handledBytes.addAndGet(packet.getByteCount());
                this.channelContext.stat.handledPacketCosts.addAndGet(iv);
                this.groupContext.groupStat.handledPackets.incrementAndGet();
                this.groupContext.groupStat.handledBytes.addAndGet(packet.getByteCount());
                this.groupContext.groupStat.handledPacketCosts.addAndGet(iv);
                if (this.groupContext.ipStats.durationList != null && this.groupContext.ipStats.durationList.size() > 0) {
                    try {
                        for (Long v : this.groupContext.ipStats.durationList) {
                            IpStat ipStat = this.groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                            ipStat.getHandledPackets().incrementAndGet();
                            ipStat.getHandledBytes().addAndGet(packet.getByteCount());
                            ipStat.getHandledPacketCosts().addAndGet(iv);
                            this.groupContext.getIpStatListener().onAfterHandled(this.channelContext, packet, ipStat, iv);
                        }
                    }
                    catch (Exception e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                }
                try {
                    this.groupContext.getAioListener().onAfterHandled(this.channelContext, packet, iv);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    public void runTask() {
        Packet packet = null;
        while ((packet = (Packet)this.msgQueue.poll()) != null) {
            this.handler(packet);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }
}

