/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslUtils;
import org.tio.core.ssl.SslVo;
import org.tio.core.utils.TioUtils;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class SendRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(SendRunnable.class);
    private ConcurrentLinkedQueue<Packet> forSendAfterSslHandshakeCompleted = null;
    private ChannelContext channelContext = null;
    private GroupContext groupContext = null;
    private AioHandler aioHandler = null;
    private boolean isSsl = false;
    private static final int MAX_CAPACITY = 50176;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentLinkedQueue<Packet> getForSendAfterSslHandshakeCompleted(boolean forceCreate) {
        if (this.forSendAfterSslHandshakeCompleted == null && forceCreate) {
            SendRunnable sendRunnable = this;
            synchronized (sendRunnable) {
                if (this.forSendAfterSslHandshakeCompleted == null) {
                    this.forSendAfterSslHandshakeCompleted = new ConcurrentLinkedQueue();
                }
            }
        }
        return this.forSendAfterSslHandshakeCompleted;
    }

    public SendRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
        this.groupContext = channelContext.groupContext;
        this.aioHandler = this.groupContext.getAioHandler();
        this.isSsl = SslUtils.isSsl(this.groupContext);
    }

    public boolean addMsg(Packet packet) {
        if (this.isCanceled()) {
            log.error("{}, \u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88\uff0c{}\u6dfb\u52a0\u5230\u53d1\u9001\u961f\u5217\u5931\u8d25", (Object)this.channelContext, (Object)packet);
            return false;
        }
        if (this.channelContext.sslFacadeContext != null && !this.channelContext.sslFacadeContext.isHandshakeCompleted() && SslUtils.needSslEncrypt(packet, this.groupContext)) {
            return this.getForSendAfterSslHandshakeCompleted(true).add(packet);
        }
        return this.msgQueue.add(packet);
    }

    public void clearMsgQueue() {
        Packet p = null;
        this.forSendAfterSslHandshakeCompleted = null;
        while ((p = (Packet)this.msgQueue.poll()) != null) {
            try {
                this.channelContext.processAfterSent(p, false);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    private ByteBuffer getByteBuffer(Packet packet) {
        try {
            ByteBuffer byteBuffer = packet.getPreEncodedByteBuffer();
            if (byteBuffer == null) {
                byteBuffer = this.aioHandler.encode(packet, this.groupContext, this.channelContext);
            }
            if (byteBuffer.position() != 0) {
                byteBuffer.flip();
            }
            return byteBuffer;
        }
        catch (Exception e) {
            log.error(packet.logstr(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static boolean swithed(Boolean oldValue, boolean newValue) {
        if (oldValue == null) {
            return false;
        }
        return !Objects.equals(oldValue, newValue);
    }

    public void runTask() {
        int queueSize = this.msgQueue.size();
        if (queueSize == 0) {
            return;
        }
        if (queueSize == 1) {
            this.sendPacket((Packet)this.msgQueue.poll());
            return;
        }
        int listInitialCapacity = Math.min(queueSize, 200);
        Packet packet = null;
        ArrayList<Packet> packets = new ArrayList<Packet>(listInitialCapacity);
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(listInitialCapacity);
        int allBytebufferCapacity = 0;
        Boolean needSslEncrypted = null;
        boolean sslSwitched = false;
        while ((packet = (Packet)this.msgQueue.poll()) != null) {
            ByteBuffer byteBuffer = this.getByteBuffer(packet);
            packets.add(packet);
            byteBuffers.add(byteBuffer);
            allBytebufferCapacity += byteBuffer.limit();
            if (this.isSsl) {
                boolean _needSslEncrypted;
                if (packet.isSslEncrypted()) {
                    _needSslEncrypted = false;
                    sslSwitched = SendRunnable.swithed(needSslEncrypted, _needSslEncrypted);
                    needSslEncrypted = _needSslEncrypted;
                } else {
                    _needSslEncrypted = true;
                    sslSwitched = SendRunnable.swithed(needSslEncrypted, _needSslEncrypted);
                    needSslEncrypted = _needSslEncrypted;
                }
            } else {
                needSslEncrypted = false;
            }
            if (allBytebufferCapacity < 50176 && !sslSwitched) continue;
            break;
        }
        if (allBytebufferCapacity == 0) {
            return;
        }
        ByteBuffer allByteBuffer = ByteBuffer.allocate(allBytebufferCapacity);
        for (ByteBuffer byteBuffer : byteBuffers) {
            allByteBuffer.put(byteBuffer);
        }
        allByteBuffer.flip();
        if (needSslEncrypted.booleanValue()) {
            SslVo sslVo = new SslVo(allByteBuffer, packets);
            try {
                this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                allByteBuffer = sslVo.getByteBuffer();
            }
            catch (SSLException e) {
                log.error(this.channelContext.toString() + ", \u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Tio.close(this.channelContext, "\u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38");
                return;
            }
        }
        this.sendByteBuffer(allByteBuffer, packets);
    }

    public boolean sendPacket(Packet packet) {
        ByteBuffer byteBuffer = this.getByteBuffer(packet);
        if (this.isSsl && !packet.isSslEncrypted()) {
            SslVo sslVo = new SslVo(byteBuffer, packet);
            try {
                this.channelContext.sslFacadeContext.getSslFacade().encrypt(sslVo);
                byteBuffer = sslVo.getByteBuffer();
            }
            catch (SSLException e) {
                log.error(this.channelContext.toString() + ", \u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38", (Throwable)e);
                Tio.close(this.channelContext, "\u8fdb\u884cSSL\u52a0\u5bc6\u65f6\u53d1\u751f\u4e86\u5f02\u5e38");
                return false;
            }
        }
        this.sendByteBuffer(byteBuffer, packet);
        return true;
    }

    public void sendByteBuffer(ByteBuffer byteBuffer, Object packets) {
        if (byteBuffer == null) {
            log.error("{},byteBuffer is null", (Object)this.channelContext);
            return;
        }
        if (!TioUtils.checkBeforeIO(this.channelContext)) {
            return;
        }
        if (!byteBuffer.hasRemaining()) {
            byteBuffer.flip();
        }
        try {
            this.channelContext.writeCompletionHandler.getWriteSemaphore().acquire();
        }
        catch (InterruptedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        WriteCompletionHandler.WriteCompletionVo writeCompletionVo = new WriteCompletionHandler.WriteCompletionVo(byteBuffer, packets);
        this.channelContext.asynchronousSocketChannel.write(byteBuffer, writeCompletionVo, this.channelContext.writeCompletionHandler);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }

    public static void main(String[] args) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.put((byte)3);
        byteBuffer.position(0);
        byteBuffer.limit(1);
        byte bs = byteBuffer.get();
        System.out.println(byteBuffer);
    }
}

