/*
 * Decompiled with CFR 0.152.
 */
package org.tio.monitor;

import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.tio.utils.SystemTimer;

public class RateLimiterWrap {
    private RateLimiter rateLimiter = null;
    private AtomicInteger warnCount = new AtomicInteger();
    private AtomicInteger allWarnCount = new AtomicInteger();
    private int maxWarnCount = 20;
    private int maxAllWarnCount = this.maxWarnCount * 10;
    private long lastWarnTime = SystemTimer.currTime;
    private int warnClearInterval = 0x6DDD00;

    public static void main(String[] args) {
    }

    public RateLimiterWrap(int permitsPerSecond, int warnClearInterval, int maxWarnCount, int maxAllWarnCount) {
        this.rateLimiter = RateLimiter.create((double)permitsPerSecond);
        this.warnClearInterval = warnClearInterval;
        this.maxWarnCount = maxWarnCount;
        this.maxAllWarnCount = maxAllWarnCount;
    }

    public AtomicInteger getAllWarnCount() {
        return this.allWarnCount;
    }

    public long getLastWarnTime() {
        return this.lastWarnTime;
    }

    public int getMaxAllWarnCount() {
        return this.maxAllWarnCount;
    }

    public int getMaxWarnCount() {
        return this.maxWarnCount;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public int getWarnClearInterval() {
        return this.warnClearInterval;
    }

    public AtomicInteger getWarnCount() {
        return this.warnCount;
    }

    public void setAllWarnCount(AtomicInteger allWarnCount) {
        this.allWarnCount = allWarnCount;
    }

    public void setLastWarnTime(long lastWarnTime) {
        this.lastWarnTime = lastWarnTime;
    }

    public void setMaxAllWarnCount(int maxAllWarnCount) {
        this.maxAllWarnCount = maxAllWarnCount;
    }

    public void setMaxWarnCount(int maxWarnCount) {
        this.maxWarnCount = maxWarnCount;
    }

    public void setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public void setWarnClearInterval(int warnClearInterval) {
        this.warnClearInterval = warnClearInterval;
    }

    public void setWarnCount(AtomicInteger warnCount) {
        this.warnCount = warnCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] tryAcquire() {
        boolean ret = this.rateLimiter.tryAcquire();
        if (!ret) {
            RateLimiterWrap rateLimiterWrap = this;
            synchronized (rateLimiterWrap) {
                long nowTime = SystemTimer.currTime;
                if (nowTime - this.lastWarnTime > (long)this.warnClearInterval) {
                    this.warnCount.set(0);
                }
                this.lastWarnTime = SystemTimer.currTime;
                int wc = this.warnCount.incrementAndGet();
                int awc = this.allWarnCount.incrementAndGet();
                if (wc > this.maxWarnCount || awc > this.maxAllWarnCount) {
                    return new boolean[]{false, false};
                }
                return new boolean[]{false, true};
            }
        }
        return new boolean[]{true, true};
    }
}

