/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.ServerGroupContext;

public class TioServer {
    private static Logger log = LoggerFactory.getLogger(TioServer.class);
    private ServerGroupContext serverGroupContext;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private AsynchronousChannelGroup channelGroup = null;
    private Node serverNode;
    private boolean isWaitingStop = false;

    public TioServer(ServerGroupContext serverGroupContext) {
        this.serverGroupContext = serverGroupContext;
    }

    public ServerGroupContext getServerGroupContext() {
        return this.serverGroupContext;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    public void setServerGroupContext(ServerGroupContext serverGroupContext) {
        this.serverGroupContext = serverGroupContext;
    }

    public void setWaitingStop(boolean isWaitingStop) {
        this.isWaitingStop = isWaitingStop;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        this.serverNode = new Node(serverIp, serverPort);
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(this.serverGroupContext.groupExecutor);
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = null;
        listenAddress = StringUtils.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, 0);
        AcceptCompletionHandler acceptCompletionHandler = this.serverGroupContext.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        log.warn("{} started, listen on {}", (Object)this.serverGroupContext.getName(), (Object)this.serverNode);
    }

    public boolean stop() {
        this.isWaitingStop = true;
        boolean ret = true;
        try {
            this.channelGroup.shutdownNow();
        }
        catch (Exception e) {
            log.error("\u5173\u95ed\u670d\u52a1\u65f6\u62a5\u9519", (Throwable)e);
        }
        try {
            this.serverSocketChannel.close();
        }
        catch (Exception e1) {
            log.error("\u5173\u95ed\u670d\u52a1\u65f6\u62a5\u9519", (Throwable)e1);
        }
        try {
            this.serverGroupContext.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        try {
            this.serverGroupContext.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        this.serverGroupContext.setStopped(true);
        try {
            ret = ret && this.serverGroupContext.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.serverGroupContext.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info(this.serverNode + " stopped");
        return ret;
    }
}

