/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.MapWithLock;

public class BsIds {
    private static Logger log = LoggerFactory.getLogger(BsIds.class);
    private MapWithLock<String, ChannelContext> map = new MapWithLock(new HashMap());

    public void bind(ChannelContext channelContext, String bsId) {
        try {
            GroupContext groupContext = channelContext.groupContext;
            if (groupContext.isShortConnection) {
                return;
            }
            this.unbind(channelContext);
            if (StrUtil.isBlank((CharSequence)bsId)) {
                return;
            }
            channelContext.setBsId(bsId);
            this.map.put((Object)bsId, (Object)channelContext);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public ChannelContext find(GroupContext groupContext, String bsId) {
        if (groupContext.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)bsId)) {
            return null;
        }
        return (ChannelContext)((Object)this.map.get((Object)bsId));
    }

    public MapWithLock<String, ChannelContext> getMap() {
        return this.map;
    }

    public void unbind(ChannelContext channelContext) {
        try {
            GroupContext groupContext = channelContext.groupContext;
            if (groupContext.isShortConnection) {
                return;
            }
            String bsId = channelContext.getBsId();
            if (StrUtil.isBlank((CharSequence)bsId)) {
                return;
            }
            this.map.remove((Object)bsId);
            channelContext.setBsId(null);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }
}

