/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SystemTimer {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "SystemTimer");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final long period = Long.parseLong(System.getProperty("system.timer.period", "10"));
    private static volatile long time = System.currentTimeMillis();

    public static long currentTimeMillis() {
        return time;
    }

    static {
        executor.scheduleAtFixedRate(new TimerTask(), period, period, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdown();
            }
        });
    }

    private static class TimerTask
    implements Runnable {
        private TimerTask() {
        }

        @Override
        public void run() {
            time = System.currentTimeMillis();
        }
    }
}

