/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread.pool;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.thread.pool.ISynRunnable;

public abstract class AbstractSynRunnable
implements ISynRunnable {
    private static Logger log = LoggerFactory.getLogger(AbstractSynRunnable.class);
    private ReadWriteLock runningLock = new ReentrantReadWriteLock();
    private Executor executor;
    private boolean isCanceled = false;

    protected AbstractSynRunnable(Executor executor) {
        this.setExecutor(executor);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.isCanceled()) {
            return;
        }
        ReadWriteLock runningLock = this.runningLock();
        Lock writeLock = runningLock.writeLock();
        boolean trylock = writeLock.tryLock();
        if (!trylock) {
            return;
        }
        try {
            this.runTask();
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            writeLock.unlock();
            if (this.isNeededExecute()) {
                this.getExecutor().execute(this);
            }
        }
    }

    @Override
    public ReadWriteLock runningLock() {
        return this.runningLock;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

