/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache.redis;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.SystemTimer;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.redis.RedisExpireUpdateTask;

public class RedisCache
implements ICache {
    private static Logger log = LoggerFactory.getLogger(RedisCache.class);
    private static Map<String, RedisCache> map = new HashMap<String, RedisCache>();
    private RedissonClient redisson = null;
    private String cacheName = null;
    private Long timeToLiveSeconds = null;
    private Long timeToIdleSeconds = null;
    private Long timeout = null;

    public static String cacheKey(String cacheName, String key) {
        return RedisCache.keyPrefix(cacheName) + key;
    }

    public static RedisCache getCache(String cacheName) {
        RedisCache redisCache = map.get(cacheName);
        if (redisCache == null) {
            log.error("cacheName[{}]\u8fd8\u6ca1\u6ce8\u518c\uff0c\u8bf7\u521d\u59cb\u5316\u65f6\u8c03\u7528\uff1a{}.register(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds)", (Object)cacheName, (Object)RedisCache.class.getSimpleName());
        }
        return redisCache;
    }

    public static String keyPrefix(String cacheName) {
        return cacheName + ":";
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisCache register(RedissonClient redisson, String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        RedisExpireUpdateTask.start();
        RedisCache redisCache = map.get(cacheName);
        if (redisCache != null) return redisCache;
        Class<RedisCache> clazz = RedisCache.class;
        synchronized (RedisCache.class) {
            redisCache = map.get(cacheName);
            if (redisCache != null) return redisCache;
            redisCache = new RedisCache(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds);
            map.put(cacheName, redisCache);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return redisCache;
        }
    }

    private RedisCache(RedissonClient redisson, String cacheName, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        this.redisson = redisson;
        this.cacheName = cacheName;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeout = this.timeToLiveSeconds == null ? this.timeToIdleSeconds : this.timeToLiveSeconds;
    }

    @Override
    public void clear() {
        long start = SystemTimer.currentTimeMillis();
        RKeys keys = this.redisson.getKeys();
        keys.deleteByPatternAsync(RedisCache.keyPrefix(this.cacheName) + "*");
        long end = SystemTimer.currentTimeMillis();
        long iv = end - start;
        log.info("clear cache {}, cost {}ms", (Object)this.cacheName, (Object)iv);
    }

    @Override
    public Serializable get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        if (bucket == null) {
            log.error("bucket is null, key:{}", (Object)key);
        }
        Serializable ret = (Serializable)bucket.get();
        if (this.timeToIdleSeconds != null && ret != null) {
            RedisExpireUpdateTask.add(this.cacheName, key, this.timeout);
        }
        return ret;
    }

    public RBucket<Serializable> getBucket(String key) {
        key = RedisCache.cacheKey(this.cacheName, key);
        RBucket bucket = this.redisson.getBucket(key);
        return bucket;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public Long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public Long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    @Override
    public Collection<String> keys() {
        RKeys keys = this.redisson.getKeys();
        Collection allkey = keys.findKeysByPattern(RedisCache.keyPrefix(this.cacheName) + "*");
        return allkey;
    }

    @Override
    public void put(String key, Serializable value) {
        long ttl;
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        long _timeout = this.timeout;
        if (this.timeToLiveSeconds != null && this.timeToLiveSeconds > 0L && (ttl = this.ttl(key)) > 0L) {
            _timeout = ttl / 1000L;
        }
        bucket.set((Object)value, _timeout, TimeUnit.SECONDS);
    }

    @Override
    public void putTemporary(String key, Serializable value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        bucket.set((Object)value, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        RBucket<Serializable> bucket = this.getBucket(key);
        bucket.delete();
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.get(key);
    }

    @Override
    public long ttl(String key) {
        RBucket<Serializable> bucket = this.getBucket(key);
        if (bucket == null) {
            return -2L;
        }
        long remainTimeToLive = bucket.remainTimeToLive();
        return remainTimeToLive;
    }
}

