/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.prop;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.prop.IPropSupport;

public class MapWithLockPropSupport
implements IPropSupport {
    private static Logger log = LoggerFactory.getLogger(MapWithLockPropSupport.class);
    private MapWithLock<String, Object> props = null;

    public static void main(String[] args) {
    }

    @Override
    public void clearAttribute() {
        this.initProps();
        ReentrantReadWriteLock.WriteLock lock = this.props.getLock().writeLock();
        lock.lock();
        try {
            Map m = (Map)this.props.getObj();
            m.clear();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object getAttribute(String key) {
        this.initProps();
        Map m = (Map)this.props.getObj();
        Object ret = m.get(key);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProps() {
        if (this.props == null) {
            MapWithLockPropSupport mapWithLockPropSupport = this;
            synchronized (mapWithLockPropSupport) {
                if (this.props == null) {
                    this.props = new MapWithLock(new HashMap(10));
                }
            }
        }
    }

    @Override
    public void removeAttribute(String key) {
        this.initProps();
        ReentrantReadWriteLock.WriteLock lock = this.props.getLock().writeLock();
        lock.lock();
        try {
            Map m = (Map)this.props.getObj();
            m.remove(key);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.initProps();
        ReentrantReadWriteLock.WriteLock lock = this.props.getLock().writeLock();
        lock.lock();
        try {
            Map m = (Map)this.props.getObj();
            m.put(key, value);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

