/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.ssl;

import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLEngineSimpleDemo {
    private static Logger log = LoggerFactory.getLogger(SSLEngineSimpleDemo.class);
    private static boolean logging = true;
    private static boolean debug = true;
    private SSLContext sslContext;
    private SSLContext clientSslContext;
    private SSLEngine clientEngine;
    private ByteBuffer clientOut;
    private ByteBuffer clientIn;
    private SSLEngine serverEngine;
    private ByteBuffer serverOut;
    private ByteBuffer serverIn;
    private ByteBuffer clientToServer;
    private ByteBuffer serverToClient;
    private static String keyStoreFile = "D:/svn_nb/nbyb/html/nbyb/web_server/nginx/conf/cert/214319727930849.jks";
    private static String trustStoreFile = "D:/svn_nb/nbyb/html/nbyb/web_server/nginx/conf/cert/214319727930849.jks";
    private static String passwd = "214319727930849";
    private static boolean resultOnce = true;

    public static void main(String[] args) throws Exception {
        if (debug) {
            System.setProperty("javax.net.debug", "all");
        }
        SSLEngineSimpleDemo demo = new SSLEngineSimpleDemo();
        demo.runDemo();
        log.info("Demo Completed.");
    }

    public SSLEngineSimpleDemo() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] passChars = passwd.toCharArray();
        keyStore.load(new FileInputStream(keyStoreFile), passChars);
        trustStore.load(new FileInputStream(trustStoreFile), passChars);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, passChars);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(trustStore);
        this.sslContext = SSLContext.getInstance("SSL");
        this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        KeyManagerFactory clientKeyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        clientKeyManagerFactory.init(null, null);
        TrustManagerFactory clientTrustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        clientTrustManagerFactory.init((KeyStore)null);
        this.clientSslContext = SSLContext.getInstance("SSL");
        this.clientSslContext.init(clientKeyManagerFactory.getKeyManagers(), clientTrustManagerFactory.getTrustManagers(), null);
    }

    private void createSSLEngines() throws Exception {
        this.serverEngine = this.sslContext.createSSLEngine();
        this.serverEngine.setUseClientMode(false);
        this.serverEngine.setNeedClientAuth(false);
        this.clientEngine = this.clientSslContext.createSSLEngine();
        this.clientEngine.setUseClientMode(true);
    }

    private void createBuffers() {
        SSLSession session = this.clientEngine.getSession();
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        SSLEngineSimpleDemo.log("AppBufferMax:" + appBufferMax);
        SSLEngineSimpleDemo.log("NetBufferMax:" + netBufferMax);
        this.clientIn = ByteBuffer.allocate(appBufferMax);
        this.serverIn = ByteBuffer.allocate(appBufferMax);
        this.clientToServer = ByteBuffer.allocate(netBufferMax);
        this.serverToClient = ByteBuffer.allocate(netBufferMax);
        this.clientOut = ByteBuffer.wrap("Hi Server, I'm Client".getBytes());
        this.serverOut = ByteBuffer.wrap("Hello Client, I'm Server".getBytes());
    }

    private void runDemo() throws Exception {
        boolean dataDone = false;
        this.createSSLEngines();
        this.createBuffers();
        while (!SSLEngineSimpleDemo.isEngineClosed(this.clientEngine) || !SSLEngineSimpleDemo.isEngineClosed(this.serverEngine)) {
            SSLEngineSimpleDemo.log("================");
            SSLEngineResult clientResult = this.clientEngine.wrap(this.clientOut, this.clientToServer);
            SSLEngineSimpleDemo.log("client wrap: ", clientResult);
            SSLEngineSimpleDemo.runDelegatedTasks(clientResult, this.clientEngine);
            SSLEngineResult serverResult = this.serverEngine.wrap(this.serverOut, this.serverToClient);
            SSLEngineSimpleDemo.log("server wrap: ", serverResult);
            SSLEngineSimpleDemo.runDelegatedTasks(serverResult, this.serverEngine);
            this.clientToServer.flip();
            this.serverToClient.flip();
            SSLEngineSimpleDemo.log("----");
            clientResult = this.clientEngine.unwrap(this.serverToClient, this.clientIn);
            SSLEngineSimpleDemo.log("client unwrap: ", clientResult);
            SSLEngineSimpleDemo.runDelegatedTasks(clientResult, this.clientEngine);
            if (clientResult.bytesConsumed() > 500) {
                SSLEngineSimpleDemo.log("\u6536\u5230\u8bc1\u4e66");
            }
            serverResult = this.serverEngine.unwrap(this.clientToServer, this.serverIn);
            SSLEngineSimpleDemo.log("server unwrap: ", serverResult);
            SSLEngineSimpleDemo.runDelegatedTasks(serverResult, this.serverEngine);
            if (serverResult.bytesConsumed() > 500) {
                SSLEngineSimpleDemo.log("\u6536\u5230\u8bc1\u4e66");
            }
            this.clientToServer.compact();
            this.serverToClient.compact();
            if (dataDone || this.clientOut.limit() != this.serverIn.position() || this.serverOut.limit() != this.clientIn.position()) continue;
            SSLEngineSimpleDemo.log(new String(this.serverIn.array()));
            SSLEngineSimpleDemo.log(new String(this.clientOut.array()));
            SSLEngineSimpleDemo.log(new String(this.serverOut.array()));
            SSLEngineSimpleDemo.log(new String(this.clientIn.array()));
            SSLEngineSimpleDemo.checkTransfer(this.serverOut, this.clientIn);
            SSLEngineSimpleDemo.checkTransfer(this.clientOut, this.serverIn);
            SSLEngineSimpleDemo.log("\tClosing clientEngine's *OUTBOUND*...");
            this.clientEngine.closeOutbound();
            this.serverEngine.closeOutbound();
            dataDone = true;
        }
    }

    private static void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) throws Exception {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = engine.getDelegatedTask()) != null) {
                SSLEngineSimpleDemo.log("\trunning delegated task...");
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = engine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new Exception("handshake shouldn't need additional tasks");
            }
            SSLEngineSimpleDemo.log("\tnew HandshakeStatus: " + (Object)((Object)hsStatus));
        }
    }

    private static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    private static void checkTransfer(ByteBuffer a, ByteBuffer b) throws Exception {
        a.flip();
        b.flip();
        if (!a.equals(b)) {
            throw new Exception("Data didn't transfer cleanly");
        }
        SSLEngineSimpleDemo.log("\tData transferred cleanly");
        a.position(a.limit());
        b.position(b.limit());
        a.limit(a.capacity());
        b.limit(b.capacity());
    }

    private static void log(String str, SSLEngineResult result) {
        if (!logging) {
            return;
        }
        if (resultOnce) {
            resultOnce = false;
            log.info("The format of the SSLEngineResult is: \n\t\"getStatus() / getHandshakeStatus()\" +\n\t\"bytesConsumed() / bytesProduced()\"\n");
        }
        SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
        SSLEngineSimpleDemo.log(str + (Object)((Object)result.getStatus()) + "/" + (Object)((Object)hsStatus) + ", " + result.bytesConsumed() + "/" + result.bytesProduced() + " bytes");
        if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            SSLEngineSimpleDemo.log("\t...ready for application data");
        }
    }

    private static void log(String str) {
        if (logging) {
            log.info(str);
        }
    }
}

