/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SystemTimer {
    private static final ScheduledExecutorService EXECUTOR = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "TioSystemTimer");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final long PERIOD = Long.parseLong(System.getProperty("system.timer.period", "10"));
    public static volatile long currTime = System.currentTimeMillis();

    public static long currentTimeMillis() {
        return currTime;
    }

    static {
        EXECUTOR.scheduleAtFixedRate(new TimerTask(), PERIOD, PERIOD, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread("TioSystemTimer-Shutdown"){

            @Override
            public void run() {
                EXECUTOR.shutdown();
            }
        });
    }

    private static class TimerTask
    implements Runnable {
        private TimerTask() {
        }

        @Override
        public void run() {
            currTime = System.currentTimeMillis();
        }
    }
}

