/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.freemarker;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtils {
    private static Logger log = LoggerFactory.getLogger(FreemarkerUtils.class);
    public static final String DEFAULT_CHARSET = "utf-8";

    public static void generateFileByFile(String templateFilePath, String destFilePath, Configuration configuration, Object model) throws IOException, TemplateException {
        FreemarkerUtils.generateFileByFile(templateFilePath, destFilePath, configuration, model, true, false);
    }

    public static void generateFileByFile(String templateFilePath, String destFilePath, Configuration configuration, Object model, boolean override) throws IOException, TemplateException {
        FreemarkerUtils.generateFileByFile(templateFilePath, destFilePath, configuration, model, override, false);
    }

    public static void generateFileByFile(String templateFilePath, String destFilePath, Configuration configuration, Object model, boolean override, boolean append) throws MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template t = configuration.getTemplate(templateFilePath);
        File destFile = new File(destFilePath);
        if (override || append || !destFile.exists()) {
            File parent = destFile.getParentFile();
            if (null != parent) {
                parent.mkdirs();
            }
            try (FileOutputStream outputStream = new FileOutputStream(destFile, append);
                 FileLock fileLock = outputStream.getChannel().tryLock();){
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream, DEFAULT_CHARSET);
                t.process(model, (Writer)out);
            }
            log.info(destFilePath + "    saved!");
        } else {
            log.error(destFilePath + "    already exists!");
        }
    }

    public static String generateStringByFile(String template, Configuration configuration) throws IOException, TemplateException {
        return FreemarkerUtils.generateStringByFile(template, configuration, new HashMap());
    }

    public static String generateStringByFile(String template, Configuration configuration, Object model) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        FreemarkerUtils.generateStringByFile(writer, template, configuration, model);
        return writer.toString();
    }

    public static void generateStringByFile(Writer writer, String template, Configuration configuration, Object model) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Template tpl = configuration.getTemplate(template);
        tpl.process(model, writer);
    }

    public static String generateStringByString(String templateContent, Configuration configuration, Object model) throws IOException, TemplateException {
        Template tpl = new Template(null, templateContent, configuration);
        StringWriter writer = new StringWriter();
        tpl.process(model, (Writer)writer);
        return writer.toString();
    }

    public static void main(String[] args) {
    }
}

