/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.http;

import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HttpUtils {
    public static final MediaType MEDIATYPE_JSON_UTF8 = MediaType.parse((String)"application/json; charset=utf-8");
    public static final OkHttpClient client = new OkHttpClient();

    public static Response get(String url, Map<String, String> headerMap) throws Exception {
        Request.Builder builder = new Request.Builder().url(url);
        if (headerMap != null) {
            Headers headers = Headers.of(headerMap);
            builder.headers(headers);
        }
        builder.get();
        Request request = builder.build();
        Response response = client.newCall(request).execute();
        return response;
    }

    public static Response get(String url) throws Exception {
        return HttpUtils.get(url, null);
    }

    private static Response post(String url, Map<String, String> headerMap, MediaType mediaType, String bodyString, Map<String, String> paramMap, List<String> paramNames, List<String> paramValues) throws Exception {
        Request.Builder builder = new Request.Builder().url(url);
        if (headerMap != null) {
            Headers headers = Headers.of(headerMap);
            builder.headers(headers);
        }
        if (StringUtils.isNotBlank((CharSequence)bodyString)) {
            if (mediaType == null) {
                mediaType = MEDIATYPE_JSON_UTF8;
            }
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)bodyString);
            builder.post(body);
        } else {
            int xx;
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            if (paramMap != null && paramMap.size() > 0) {
                Set<Map.Entry<String, String>> set = paramMap.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    formBodyBuilder.add(entry.getKey(), entry.getValue());
                }
            } else if (paramNames != null && (xx = paramNames.size()) > 0) {
                for (int i = 0; i < xx; ++i) {
                    formBodyBuilder.add(paramNames.get(i), paramValues.get(i));
                }
            }
            FormBody formBody = formBodyBuilder.build();
            builder.post((RequestBody)formBody);
        }
        Request request = builder.build();
        Response response = client.newCall(request).execute();
        return response;
    }

    public static Response post(String url, Map<String, String> headerMap, List<String> paramNames, List<String> paramValues) throws Exception {
        return HttpUtils.post(url, headerMap, null, null, null, paramNames, paramValues);
    }

    public static Response post(String url, Map<String, String> headerMap, Map<String, String> paramMap) throws Exception {
        return HttpUtils.post(url, headerMap, null, null, paramMap, null, null);
    }

    public static Response post(String url, Map<String, String> headerMap, String bodyString) throws Exception {
        return HttpUtils.post(url, headerMap, null, bodyString, null, null, null);
    }

    public static Response post(String url, Map<String, String> headerMap) throws Exception {
        return HttpUtils.post(url, headerMap, null, null, null, null, null);
    }

    public static Response post(String url) throws Exception {
        return HttpUtils.post(url, null);
    }

    public static void main(String[] args) throws Exception {
        Response x = HttpUtils.post("https://beta.nb350.com/tio");
        System.out.println(x.body().string());
        x = HttpUtils.get("https://open.weixin.qq.com/");
        System.out.println(x.body().string());
    }
}

