/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.guava;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaUtils {
    private static Logger log = LoggerFactory.getLogger(GuavaUtils.class);

    public static <K, V> LoadingCache<K, V> createLoadingCache(Integer concurrencyLevel, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats) {
        return GuavaUtils.createLoadingCache(concurrencyLevel, timeToLiveSeconds, timeToIdleSeconds, initialCapacity, maximumSize, recordStats, null);
    }

    public static <K, V> LoadingCache<K, V> createLoadingCache(Integer concurrencyLevel, Long timeToLiveSeconds, Long timeToIdleSeconds, Integer initialCapacity, Integer maximumSize, boolean recordStats, RemovalListener<K, V> removalListener) {
        if (removalListener == null) {
            removalListener = new RemovalListener<K, V>(){

                public void onRemoval(RemovalNotification<K, V> notification) {
                    log.info(notification.getKey() + " was removed");
                }
            };
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().removalListener(removalListener);
        cacheBuilder.concurrencyLevel(concurrencyLevel.intValue());
        if (timeToLiveSeconds != null && timeToLiveSeconds > 0L) {
            cacheBuilder.expireAfterWrite(timeToLiveSeconds.longValue(), TimeUnit.SECONDS);
        }
        if (timeToIdleSeconds != null && timeToIdleSeconds > 0L) {
            cacheBuilder.expireAfterAccess(timeToIdleSeconds.longValue(), TimeUnit.SECONDS);
        }
        cacheBuilder.initialCapacity(initialCapacity.intValue());
        cacheBuilder.maximumSize((long)maximumSize.intValue());
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        LoadingCache loadingCache = cacheBuilder.build(new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return null;
            }
        });
        return loadingCache;
    }
}

