/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import org.redisson.api.RedissonClient;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.cache.caffeine.CaffeineCache;
import org.tio.utils.cache.caffeineredis.CaffeineRedisCache;
import org.tio.utils.lock.LockUtils;

public abstract class CacheUtils {
    private static final String PREFIX_TIMETOLIVESECONDS = CacheUtils.class.getName() + "_live";
    private static final String PREFIX_TIMETOIDLESECONDS = CacheUtils.class.getName() + "_idle";
    private static final Object LOCK_FOR_GETCACHE = new Object();
    private static final NullClass NULL_OBJ = new NullClass();

    private CacheUtils() {
    }

    public static <T extends Serializable> T get(Long timeToLiveSeconds, Long timeToIdleSeconds, String cacheKey, FirsthandCreater<T> firsthandCreater) {
        return CacheUtils.get(timeToLiveSeconds, timeToIdleSeconds, cacheKey, false, firsthandCreater);
    }

    public static <T extends Serializable> T get(Long timeToLiveSeconds, Long timeToIdleSeconds, String cacheKey, boolean putTempToCacheIfNull, FirsthandCreater<T> firsthandCreater) {
        CaffeineCache cache = CacheUtils.getCaffeineCache(timeToLiveSeconds, timeToIdleSeconds);
        return CacheUtils.get(cache, cacheKey, putTempToCacheIfNull, firsthandCreater);
    }

    public static <T extends Serializable> T get(ICache cache, String cacheKey, FirsthandCreater<T> firsthandCreater) {
        return CacheUtils.get(cache, cacheKey, false, firsthandCreater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T get(ICache cache, String cacheKey, boolean putTempToCacheIfNull, FirsthandCreater<T> firsthandCreater) {
        Serializable lock;
        Serializable ret = cache.get(cacheKey);
        if (ret != null) {
            if (ret instanceof NullClass) {
                return null;
            }
            return (T)ret;
        }
        String lockKey = cache.getCacheName() + cacheKey;
        Serializable serializable = lock = LockUtils.getLockObj(lockKey, cache);
        synchronized (serializable) {
            ret = cache.get(cacheKey);
            if (ret != null) {
                if (ret instanceof NullClass) {
                    return null;
                }
                return (T)ret;
            }
            ret = firsthandCreater.create();
            if (ret == null) {
                if (putTempToCacheIfNull) {
                    cache.putTemporary(cacheKey, NULL_OBJ);
                }
            } else {
                cache.put(cacheKey, ret);
            }
        }
        return (T)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CaffeineCache getCaffeineCache(Long timeToLiveSeconds, Long timeToIdleSeconds) {
        String cacheName = CacheUtils.getCacheName(timeToLiveSeconds, timeToIdleSeconds);
        CaffeineCache caffeineCache = CaffeineCache.getCache(cacheName, true);
        if (caffeineCache == null) {
            Object object = LOCK_FOR_GETCACHE;
            synchronized (object) {
                caffeineCache = CaffeineCache.getCache(cacheName, true);
                if (caffeineCache == null) {
                    caffeineCache = CaffeineCache.register(cacheName, timeToLiveSeconds, timeToIdleSeconds);
                }
            }
        }
        return caffeineCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CaffeineRedisCache getCaffeineRedisCache(RedissonClient redisson, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        String cacheName = CacheUtils.getCacheName(timeToLiveSeconds, timeToIdleSeconds);
        CaffeineRedisCache caffeineCache = CaffeineRedisCache.getCache(cacheName, true);
        if (caffeineCache == null) {
            Object object = LOCK_FOR_GETCACHE;
            synchronized (object) {
                caffeineCache = CaffeineRedisCache.getCache(cacheName, true);
                if (caffeineCache == null) {
                    caffeineCache = CaffeineRedisCache.register(redisson, cacheName, timeToLiveSeconds, timeToIdleSeconds);
                }
            }
        }
        return caffeineCache;
    }

    private static String getCacheName(Long timeToLiveSeconds, Long timeToIdleSeconds) {
        if (timeToLiveSeconds != null) {
            return PREFIX_TIMETOLIVESECONDS + timeToLiveSeconds;
        }
        if (timeToIdleSeconds != null) {
            return PREFIX_TIMETOIDLESECONDS + timeToIdleSeconds;
        }
        throw new RuntimeException("timeToLiveSeconds\u548ctimeToIdleSeconds\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a");
    }

    public static void main(String[] args) {
    }

    private static class NullClass
    implements Serializable {
        private static final long serialVersionUID = -2298613658358477523L;

        private NullClass() {
        }
    }
}

