/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tio.utils.hutool.Validator;

public class DateUtil {
    private static Date toDate(String dateStr, String patternStr) {
        Date date;
        SimpleDateFormat fmt = new SimpleDateFormat(patternStr);
        try {
            date = fmt.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    public static String guessPattern(String dateStr) {
        dateStr = dateStr.trim().replace("\u65e5", "");
        int length = dateStr.length();
        if (Validator.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return "yyyyMMddHHmmss";
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return "yyyyMMddHHmmssSSS";
            }
            if (length == "yyyyMMdd".length()) {
                return "yyyyMMdd";
            }
            if (length == "HHmmss".length()) {
                return "HHmmss";
            }
        }
        if (length == "yyyy-MM-dd HH:mm:ss".length() || length == "yyyy-MM-dd HH:mm:ss".length() + 1) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        if (length == "yyyy-MM-dd".length()) {
            return "yyyy-MM-dd";
        }
        if (length == "HH:mm:ss".length() || length == "HH:mm:ss".length() + 1) {
            return "HH:mm:ss";
        }
        if (length == "yyyy-MM-dd HH:mm".length() || length == "yyyy-MM-dd HH:mm".length() + 1) {
            return "yyyy-MM-dd HH:mm";
        }
        if (length >= "yyyy-MM-dd HH:mm:ss.SSS".length() - 2) {
            return "yyyy-MM-dd HH:mm:ss.SSS";
        }
        return null;
    }

    public static Date parseToDate(String dateStr) {
        String p = DateUtil.guessPattern(dateStr);
        if (p == null) {
            return null;
        }
        return DateUtil.toDate(dateStr, p);
    }

    public static java.sql.Date parseToSqlDate(String dateStr) {
        Date d = DateUtil.parseToDate(dateStr);
        if (d == null) {
            return null;
        }
        return new java.sql.Date(d.getTime());
    }

    public static Timestamp parseToTimestamp(String dateStr) {
        Date d = DateUtil.parseToDate(dateStr);
        if (d == null) {
            return null;
        }
        return new Timestamp(d.getTime());
    }

    public static Time parseToTime(String dateStr) {
        Date d = DateUtil.parseToDate(dateStr);
        if (d == null) {
            return null;
        }
        return new Time(d.getTime());
    }
}

