/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ISVNWCDb {
    public static final int WC_FORMAT_17 = 29;
    public static final int WC_FORMAT_18 = 31;
    public static final int WC_HAS_WORK_QUEUE = 13;
    public static final long INVALID_FILESIZE = -1L;
    public static final long INVALID_REVNUM = -1L;
    public static final String SDB_FILE = "wc.db";
    public static final String SDB_FILE_UPGRADE = "wc.db.upgrade";
    public static final String PRISTINE_STORAGE_RELPATH = "pristine";
    public static final String PRISTINE_TEMPDIR_RELPATH = "";
    public static final String WCROOT_TEMPDIR_RELPATH = "tmp";

    public void open(SVNWCDbOpenMode var1, ISVNOptions var2, boolean var3, boolean var4);

    public void close();

    public ISVNOptions getConfig();

    public void init(File var1, File var2, SVNURL var3, String var4, long var5, SVNDepth var7, int var8) throws SVNException;

    public File toRelPath(File var1) throws SVNException;

    public File toRelPath(File var1, File var2) throws SVNException;

    public File fromRelPath(File var1, File var2) throws SVNException;

    public void addBaseDirectory(File var1, File var2, SVNURL var3, String var4, long var5, SVNProperties var7, long var8, SVNDate var10, String var11, List<File> var12, SVNDepth var13, SVNProperties var14, SVNSkel var15, boolean var16, SVNProperties var17, Map<String, SVNProperties> var18, SVNSkel var19) throws SVNException;

    public void addBaseFile(File var1, File var2, SVNURL var3, String var4, long var5, SVNProperties var7, long var8, SVNDate var10, String var11, SvnChecksum var12, SVNProperties var13, boolean var14, boolean var15, SVNProperties var16, boolean var17, boolean var18, Map<String, SVNProperties> var19, SVNSkel var20, SVNSkel var21) throws SVNException;

    public void addBaseSymlink(File var1, File var2, SVNURL var3, String var4, long var5, SVNProperties var7, long var8, SVNDate var10, String var11, File var12, SVNProperties var13, SVNSkel var14, boolean var15, SVNProperties var16, SVNSkel var17) throws SVNException;

    public void addBaseExcludedNode(File var1, File var2, SVNURL var3, String var4, long var5, SVNWCDbKind var7, SVNWCDbStatus var8, SVNSkel var9, SVNSkel var10) throws SVNException;

    public void removeBase(File var1) throws SVNException;

    public void removeBase(File var1, boolean var2, boolean var3, boolean var4, long var5, SVNSkel var7, SVNSkel var8) throws SVNException;

    public WCDbBaseInfo getBaseInfo(File var1, WCDbBaseInfo.BaseInfoField ... var2) throws SVNException;

    public SVNProperties getBaseProps(File var1) throws SVNException;

    public Set<String> getBaseChildren(File var1) throws SVNException;

    public Map<String, WCDbBaseInfo> getBaseChildrenMap(File var1, boolean var2) throws SVNException;

    public Map<String, WCDbBaseInfo> getBaseChildrenMap(SVNWCDbRoot var1, File var2, boolean var3) throws SVNException;

    public void setBaseDavCache(File var1, SVNProperties var2) throws SVNException;

    public SVNProperties getBaseDavCache(File var1) throws SVNException;

    public void clearDavCacheRecursive(File var1) throws SVNException;

    public File getPristinePath(File var1, SvnChecksum var2) throws SVNException;

    public InputStream readPristine(File var1, SvnChecksum var2) throws SVNException;

    public File getPristineTempDir(File var1) throws SVNException;

    public void installPristine(File var1, SvnChecksum var2, SvnChecksum var3) throws SVNException;

    public SvnChecksum getPristineMD5(File var1, SvnChecksum var2) throws SVNException;

    public SvnChecksum getPristineSHA1(File var1, SvnChecksum var2) throws SVNException;

    public void removePristine(File var1, SvnChecksum var2) throws SVNException;

    public void cleanupPristine(File var1) throws SVNException;

    public boolean checkPristine(File var1, SvnChecksum var2) throws SVNException;

    public void opCopy(File var1, File var2, File var3, boolean var4, SVNSkel var5) throws SVNException;

    public void opCopyShadowedLayer(File var1, File var2, boolean var3) throws SVNException;

    public void opCopyDir(File var1, SVNProperties var2, long var3, SVNDate var5, String var6, File var7, SVNURL var8, String var9, long var10, List<File> var12, boolean var13, SVNDepth var14, SVNSkel var15, SVNSkel var16) throws SVNException;

    public void opCopyFile(File var1, SVNProperties var2, long var3, SVNDate var5, String var6, File var7, SVNURL var8, String var9, long var10, SvnChecksum var12, boolean var13, SVNProperties var14, SVNSkel var15, SVNSkel var16) throws SVNException;

    public void opAddDirectory(File var1, SVNProperties var2, SVNSkel var3) throws SVNException;

    public void opAddFile(File var1, SVNProperties var2, SVNSkel var3) throws SVNException;

    public void opAddSymlink(File var1, File var2, SVNProperties var3, SVNSkel var4) throws SVNException;

    public void opSetProps(File var1, SVNProperties var2, SVNSkel var3, boolean var4, SVNSkel var5) throws SVNException;

    public void opDelete(File var1, File var2, boolean var3, SVNSkel var4, SVNSkel var5, ISVNEventHandler var6) throws SVNException;

    public void opSetChangelist(File var1, String var2, String[] var3, SVNDepth var4, ISVNEventHandler var5) throws SVNException;

    public void opMarkResolved(File var1, boolean var2, boolean var3, boolean var4, SVNSkel var5) throws SVNException;

    public void opMarkConflict(File var1, SVNSkel var2, SVNSkel var3) throws SVNException;

    public void opRevert(File var1, SVNDepth var2) throws SVNException;

    public Map<String, SVNTreeConflictDescription> opReadAllTreeConflicts(File var1) throws SVNException;

    public SVNTreeConflictDescription opReadTreeConflict(File var1) throws SVNException;

    public void opSetTreeConflict(File var1, SVNTreeConflictDescription var2) throws SVNException;

    public WCDbInfo readInfo(File var1, WCDbInfo.InfoField ... var2) throws SVNException;

    public Structure<StructureFields.NodeInfo> readInfo(File var1, StructureFields.NodeInfo ... var2) throws SVNException;

    public Structure<StructureFields.NodeInfo> readInfo(File var1, boolean var2, StructureFields.NodeInfo ... var3) throws SVNException;

    public SVNProperties readProperties(File var1) throws SVNException;

    public SVNProperties readPristineProperties(File var1) throws SVNException;

    public Set<String> readChildren(File var1) throws SVNException;

    public void readChildren(File var1, Map<String, SVNWCDbInfo> var2, Set<String> var3) throws SVNException;

    public List<String> readConflictVictims(File var1) throws SVNException;

    public List<SVNConflictDescription> readConflicts(File var1) throws SVNException;

    public SVNSkel readConflict(File var1) throws SVNException;

    public SVNWCDbKind readKind(File var1, boolean var2) throws SVNException;

    public SVNNodeKind readKind(File var1, boolean var2, boolean var3, boolean var4) throws SVNException;

    public boolean isNodeHidden(File var1) throws SVNException;

    public void globalCommit(File var1, long var2, long var4, SVNDate var6, String var7, SvnChecksum var8, List<File> var9, SVNProperties var10, boolean var11, boolean var12, SVNSkel var13) throws SVNException;

    public void globalRecordFileinfo(File var1, long var2, SVNDate var4) throws SVNException;

    public void addLock(File var1, SVNWCDbLock var2) throws SVNException;

    public void removeLock(File var1) throws SVNException;

    public WCDbRepositoryInfo scanBaseRepository(File var1, WCDbRepositoryInfo.RepositoryInfoField ... var2) throws SVNException;

    public WCDbAdditionInfo scanAddition(File var1, WCDbAdditionInfo.AdditionInfoField ... var2) throws SVNException;

    public WCDbDeletionInfo scanDeletion(File var1, WCDbDeletionInfo.DeletionInfoField ... var2) throws SVNException;

    public void addWorkQueue(File var1, SVNSkel var2) throws SVNException;

    public WCDbWorkQueueInfo fetchWorkQueue(File var1) throws SVNException;

    public void completedWorkQueue(File var1, long var2) throws SVNException;

    public boolean isWCLocked(File var1) throws SVNException;

    public boolean isWCRoot(File var1) throws SVNException;

    public boolean isWCRoot(File var1, boolean var2) throws SVNException;

    public int getFormatTemp(File var1) throws SVNException;

    public String getFileExternalTemp(File var1) throws SVNException;

    public SVNSqlJetDb borrowDbTemp(File var1, SVNWCDbOpenMode var2) throws SVNException;

    public void opStartDirectoryUpdateTemp(File var1, File var2, long var3) throws SVNException;

    public void opMakeCopyTemp(File var1, boolean var2) throws SVNException;

    public void opSetNewDirToIncompleteTemp(File var1, File var2, SVNURL var3, String var4, long var5, SVNDepth var7, boolean var8, boolean var9, SVNSkel var10, SVNSkel var11) throws SVNException;

    public File getWCRootTempDir(File var1) throws SVNException;

    public void opRemoveWorkingTemp(File var1) throws SVNException;

    public void opSetBaseIncompleteTemp(File var1, boolean var2) throws SVNException;

    public void opSetDirDepthTemp(File var1, SVNDepth var2) throws SVNException;

    public void opRemoveEntryTemp(File var1) throws SVNException;

    public void opSetRevAndReposRelpathTemp(File var1, long var2, boolean var4, File var5, SVNURL var6, String var7) throws SVNException;

    public void obtainWCLock(File var1, int var2, boolean var3) throws SVNException;

    public void releaseWCLock(File var1) throws SVNException;

    public File getWCRoot(File var1) throws SVNException;

    public void forgetDirectoryTemp(File var1) throws SVNException;

    public boolean isWCLockOwns(File var1, boolean var2) throws SVNException;

    public void opSetTextConflictMarkerFilesTemp(File var1, File var2, File var3, File var4) throws SVNException;

    public void addBaseNotPresentNode(File var1, File var2, SVNURL var3, String var4, long var5, SVNWCDbKind var7, SVNSkel var8, SVNSkel var9) throws SVNException;

    public void opSetPropertyConflictMarkerFileTemp(File var1, String var2) throws SVNException;

    public void opBumpRevisionPostUpdate(File var1, SVNDepth var2, File var3, SVNURL var4, String var5, long var6, Collection<File> var8, Map<File, Map<String, SVNProperties>> var9, ISVNEventHandler var10) throws SVNException;

    public Map<File, File> getExternalsDefinedBelow(File var1) throws SVNException;

    public void gatherExternalDefinitions(File var1, SVNExternalsStore var2) throws SVNException;

    public WCDbInfo readInfoBelowWorking(File var1) throws SVNException;

    public Structure<StructureFields.PristineInfo> readPristineInfo(File var1) throws SVNException;

    public void registerExternal(File var1, File var2, SVNNodeKind var3, SVNURL var4, String var5, File var6, long var7, long var9) throws SVNException;

    public Set<String> getChildrenOfWorkingNode(File var1) throws SVNException;

    public void opRemoveNode(File var1, long var2, SVNWCDbKind var4) throws SVNException;

    public void upgradeBegin(File var1, SVNWCDbUpgradeData var2, SVNURL var3, String var4) throws SVNException;

    public SVNWCDbNodeCheckReplaceData nodeCheckReplace(File var1) throws SVNException;

    public SVNSqlJetDb getSDb(File var1) throws SVNException;

    public SVNWCDbBaseMovedToData baseMovedTo(File var1) throws SVNException;

    public NodeInstallInfo readNodeInstallInfo(File var1, File var2) throws SVNException;

    public void resolveBreakMovedAway(File var1, ISVNEventHandler var2) throws SVNException;

    public void resolveDeleteRaiseMovedAway(File var1, ISVNEventHandler var2) throws SVNException;

    public void updateMovedAwayConflictVictim(File var1, ISVNEventHandler var2) throws SVNException;

    public SwitchedInfo isSwitched(File var1) throws SVNException;

    public List<File> getConflictMarkerFiles(File var1) throws SVNException;

    public long[] minMaxRevisions(File var1, boolean var2) throws SVNException;

    public boolean opHandleMoveBack(File var1, File var2, SVNSkel var3) throws SVNException;

    public File requiredLockForResolve(File var1) throws SVNException;

    public Map<SVNURL, String> getNodeLockTokensRecursive(File var1) throws SVNException;

    public List<SVNWCContext.CommittableExternalInfo> committableExternalsBelow(File var1, boolean var2) throws SVNException;

    public Moved scanMoved(File var1) throws SVNException;

    public void dropRoot(File var1) throws SVNException;

    public void upgradeInsertExternal(File var1, SVNNodeKind var2, File var3, File var4, File var5, SVNURL var6, String var7, long var8, long var10) throws SVNException;

    public static class Moved {
        public File movedFromAbsPath;
        public File opRootAbsPath;
        public File opRootMovedFromAbsPath;
        public File movedFromDeleteAbsPath;
    }

    public static class SwitchedInfo {
        public boolean isWcRoot;
        public boolean isSwitched;
        public SVNWCDbKind kind;
    }

    public static class NodeInstallInfo {
        public SVNWCDbRoot wcRoot;
        public SvnChecksum checksum;
        public SVNProperties properties;
        public SVNDate changedDate;
    }

    public static class SVNWCDbBaseMovedToData {
        public File moveDstAbsPath;
        public File moveDstOpRootAbsPath;
        public File moveSrcRootAbsPath;
        public File moveSrcOpRootAbsPath;
    }

    public static class SVNWCDbNodeCheckReplaceData {
        public static SVNWCDbNodeCheckReplaceData NO_REPLACE = new SVNWCDbNodeCheckReplaceData(false, false, false);
        public final boolean replaceRoot;
        public final boolean replace;
        public final boolean baseReplace;

        public SVNWCDbNodeCheckReplaceData(boolean replaceRoot, boolean replace, boolean baseReplace) {
            this.replaceRoot = replaceRoot;
            this.replace = replace;
            this.baseReplace = baseReplace;
        }
    }

    public static class SVNWCDbUpgradeData {
        public File rootAbsPath;
        public long repositoryId;
        public long workingCopyId;
        public SVNWCDbRoot root;
    }

    public static class WCDbWorkQueueInfo {
        public long id;
        public SVNSkel workItem;
    }

    public static class WCDbDeletionInfo {
        public File baseDelAbsPath;
        public boolean baseReplaced;
        public File movedToAbsPath;
        public File workDelAbsPath;
        public File movedToOpRootAbsPath;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DeletionInfoField {
            baseDelAbsPath,
            baseReplaced,
            movedToAbsPath,
            workDelAbsPath,
            movedToOpRootAbsPath;

        }
    }

    public static class WCDbAdditionInfo {
        public SVNWCDbStatus status;
        public File opRootAbsPath;
        public File reposRelPath;
        public SVNURL reposRootUrl;
        public String reposUuid;
        public File originalReposRelPath;
        public SVNURL originalRootUrl;
        public String originalUuid;
        public long originalRevision;
        public long originalReposId;
        public File movedFromRelPath;
        public File movedFromOpRootRelPath;
        public int movedFromOpDepth;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum AdditionInfoField {
            status,
            opRootAbsPath,
            reposRelPath,
            reposRootUrl,
            reposUuid,
            originalReposRelPath,
            originalReposId,
            originalRootUrl,
            originalUuid,
            originalRevision,
            movedFromRelPath,
            movedFromOpRootRelPath;

        }
    }

    public static class WCDbRepositoryInfo {
        public File relPath;
        public SVNURL rootUrl;
        public String uuid;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RepositoryInfoField {
            relPath,
            rootUrl,
            uuid;

        }
    }

    public static class WCDbInfo {
        public SVNWCDbStatus status;
        public SVNWCDbKind kind;
        public long revision;
        public File reposRelPath;
        public SVNURL reposRootUrl;
        public String reposUuid;
        public long changedRev;
        public SVNDate changedDate;
        public String changedAuthor;
        public long lastModTime;
        public long reposId;
        public SVNDepth depth;
        public SvnChecksum checksum;
        public long translatedSize;
        public File target;
        public String changelist;
        public File originalReposRelpath;
        public SVNURL originalRootUrl;
        public String originalUuid;
        public long originalRevision;
        public long originalReposId;
        public boolean textMod;
        public boolean propsMod;
        public boolean conflicted;
        public SVNWCDbLock lock;
        public boolean haveBase;
        public boolean haveWork;
        public boolean opRoot;
        public boolean hadProps;
        public boolean haveMoreWork;
        public boolean movedHere;
        public File movedToAbsPath;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InfoField {
            status,
            kind,
            revision,
            reposRelPath,
            reposId,
            reposRootUrl,
            reposUuid,
            changedRev,
            changedDate,
            changedAuthor,
            lastModTime,
            depth,
            checksum,
            translatedSize,
            target,
            changelist,
            originalReposRelpath,
            originalRootUrl,
            originalUuid,
            originalRevision,
            textMod,
            propsMod,
            conflicted,
            lock,
            haveBase,
            haveWork,
            opRoot,
            originalReposId,
            hadProps,
            haveMoreWork,
            movedHere,
            movedTo;

        }
    }

    public static class WCDbBaseInfo {
        public SVNWCDbStatus status;
        public SVNWCDbKind kind;
        public long revision;
        public File reposRelPath;
        public SVNURL reposRootUrl;
        public String reposUuid;
        public long reposId;
        public long changedRev;
        public SVNDate changedDate;
        public String changedAuthor;
        public SVNDate lastModTime;
        public SVNDepth depth;
        public SvnChecksum checksum;
        public long translatedSize;
        public File target;
        public boolean updateRoot;
        public SVNWCDbLock lock;
        public boolean hadProps;
        public SVNProperties props;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum BaseInfoField {
            status,
            kind,
            revision,
            reposRelPath,
            reposRootUrl,
            reposUuid,
            changedRev,
            changedDate,
            changedAuthor,
            lastModTime,
            depth,
            checksum,
            translatedSize,
            target,
            lock,
            updateRoot,
            reposId,
            hadProps,
            props;

        }
    }

    public static class SVNWCDbInfo {
        public SVNWCDbStatus status;
        public SVNWCDbKind kind;
        public long revnum;
        public File reposRelpath;
        public SVNURL reposRootUrl;
        public String reposUuid;
        public long changedRev;
        public String changedAuthor;
        public SVNDate changedDate;
        public SVNDepth depth;
        public long recordedSize;
        public long recordedModTime;
        public String changelist;
        public boolean conflicted;
        public boolean special;
        public boolean opRoot;
        public boolean hasChecksum;
        public boolean hadProps;
        public boolean propsMod;
        public boolean haveBase;
        public boolean haveMoreWork;
        public boolean locked;
        public SVNWCDbLock lock;
        public boolean incomplete;
        public File movedToAbsPath;
        public boolean movedHere;
        public boolean fileExternal;
        public boolean copied;
        public int format;

        public void load(WCDbInfo info) {
            if (info == null) {
                return;
            }
            this.status = info.status;
            this.kind = info.kind;
            this.revnum = info.revision;
            this.reposRelpath = info.reposRelPath;
            this.reposRootUrl = info.reposRootUrl;
            this.reposUuid = info.reposUuid;
            this.changedRev = info.changedRev;
            this.changedAuthor = info.changedAuthor;
            this.changedDate = info.changedDate;
            this.depth = info.depth;
            this.recordedSize = info.translatedSize;
            this.recordedModTime = info.lastModTime;
            this.changelist = info.changelist;
            this.conflicted = info.conflicted;
            this.opRoot = info.opRoot;
            this.hasChecksum = info.checksum != null;
            this.hadProps = info.hadProps;
            this.propsMod = info.propsMod;
            this.haveBase = info.haveBase;
            this.haveMoreWork = info.haveMoreWork;
            this.locked = info.lock != null;
            this.lock = info.lock;
            this.incomplete = info.status == SVNWCDbStatus.Incomplete;
            this.movedHere = info.movedHere;
            this.movedToAbsPath = info.movedToAbsPath;
            this.fileExternal = false;
            this.format = -1;
        }
    }

    public static class SVNWCDbLock {
        public String token;
        public String owner;
        public String comment;
        public SVNDate date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SVNWCDbStatus {
        Normal,
        Added,
        MovedHere,
        Copied,
        Deleted,
        Obstructed,
        ObstructedDelete,
        ObstructedAdd,
        ServerExcluded,
        Excluded,
        NotPresent,
        Incomplete,
        BaseDeleted;


        public boolean isNotPresent() {
            return this == Excluded || this == ServerExcluded || this == NotPresent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SVNWCDbKind {
        Dir,
        File,
        Symlink,
        Unknown;


        public SVNNodeKind toNodeKind() throws SVNException {
            switch (this) {
                case Dir: {
                    return SVNNodeKind.DIR;
                }
                case File: 
                case Symlink: {
                    return SVNNodeKind.FILE;
                }
                case Unknown: {
                    return SVNNodeKind.UNKNOWN;
                }
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL);
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }

        public SVNNodeKind toNodeKind(SVNWCDbStatus status, boolean showHidden) throws SVNException {
            SVNNodeKind nKind = this.toNodeKind();
            if (!showHidden && status != null) {
                switch (status) {
                    case NotPresent: 
                    case ServerExcluded: 
                    case Excluded: {
                        nKind = SVNNodeKind.NONE;
                    }
                }
            }
            return nKind;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SVNWCDbOpenMode {
        Default,
        ReadOnly,
        ReadWrite;

    }
}

