/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCatCommand
extends SVNCommand {
    public SVNCatCommand() {
        super("cat", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        return options;
    }

    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        boolean seenNonExistentTarget = false;
        for (int i = 0; i < targets.size(); ++i) {
            SVNPath target = new SVNPath(targets.get(i), true);
            try {
                if (target.isURL()) {
                    client.doGetFileContents(target.getURL(), target.getPegRevision(), this.getSVNEnvironment().getStartRevision(), true, (OutputStream)this.getSVNEnvironment().getOut());
                    continue;
                }
                client.doGetFileContents(target.getFile(), target.getPegRevision(), this.getSVNEnvironment().getStartRevision(), true, (OutputStream)this.getSVNEnvironment().getOut());
                continue;
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                this.getSVNEnvironment().handleWarning(err, new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.ENTRY_NOT_FOUND, SVNErrorCode.CLIENT_IS_DIRECTORY, SVNErrorCode.FS_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                seenNonExistentTarget = true;
            }
        }
        if (seenNonExistentTarget) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Could not cat all targets because some targets don't exist");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }
}

