/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNDiffCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNewDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLogCommand
extends SVNXMLCommand
implements ISVNLogEntryHandler {
    private static final String SEPARATOR = "------------------------------------------------------------------------\n";
    private LinkedList myMergeStack;
    private String myAuthorOfInterest;
    private String myLogRegularExpression;
    private SVNPath myTarget;
    private SVNDepth myDepth;

    public SVNLogCommand() {
        super("log", null);
    }

    public boolean acceptsRevisionRange() {
        return true;
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.DIFF);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.USE_MERGE_HISTORY);
        options.add(SVNOption.CHANGE);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.STOP_ON_COPY);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        options.add(SVNOption.LIMIT);
        options.add(SVNOption.WITH_ALL_REVPROPS);
        options.add(SVNOption.WITH_NO_REVPROPS);
        options.add(SVNOption.WITH_REVPROP);
        options.add(SVNOption.AUTHOR_OF_INTEREST);
        options.add(SVNOption.REGULAR_EXPRESSION);
        return options;
    }

    public void run() throws SVNException {
        SVNErrorMessage err;
        LinkedList<SVNRevisionRange> revisionRanges;
        SVNErrorMessage err2;
        if (!this.getSVNEnvironment().isXML()) {
            if (this.getSVNEnvironment().isAllRevisionProperties()) {
                err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'with-all-revprops' option only valid in XML mode");
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
            if (this.getSVNEnvironment().getRevisionProperties() != null) {
                err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'with-revprop' option only valid in XML mode");
                SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (this.getSVNEnvironment().isShowDiff()) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'diff' option is not supported in XML mode");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.getSVNEnvironment().isQuiet() && this.getSVNEnvironment().isShowDiff()) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'quiet' and 'diff' options are mutually exclusive");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.getSVNEnvironment().getDiffCommand() != null && !this.getSVNEnvironment().isShowDiff()) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'diff-cmd' option requires 'diff' option");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.getSVNEnvironment().getExtensions() != null && !this.getSVNEnvironment().isShowDiff()) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'extensions' option requires 'diff' option");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        if (this.getSVNEnvironment().getDepth() != SVNDepth.UNKNOWN && !this.getSVNEnvironment().isShowDiff()) {
            err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'depth' option requires 'diff' option");
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        }
        List<Object> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        if ((targets = this.getSVNEnvironment().combineTargets(targets, true)).isEmpty()) {
            targets.add("");
        }
        SVNPath target = new SVNPath((String)targets.get(0), true);
        SVNRevision start = this.getSVNEnvironment().getStartRevision();
        SVNRevision end = this.getSVNEnvironment().getEndRevision();
        LinkedList<SVNRevisionRange> editedRevisionRangesList = revisionRanges = this.getSVNEnvironment().getRevisionRanges();
        if (this.getSVNEnvironment().isChangeOptionUsed()) {
            editedRevisionRangesList = new LinkedList<SVNRevisionRange>();
            if (this.getSVNEnvironment().isRevisionOptionUsed() && revisionRanges.size() > 1) {
                err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_BAD_REVISION, (String)"-c and -r are mutually exclusive");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            for (SVNRevisionRange revRange : revisionRanges) {
                SVNRevision startRev = revRange.getStartRevision();
                SVNRevision endRev = revRange.getEndRevision();
                revRange = startRev.getNumber() < endRev.getNumber() && startRev.getNumber() >= 0L && endRev.getNumber() >= 0L ? new SVNRevisionRange(SVNRevision.create((long)(startRev.getNumber() + 1L)), endRev) : new SVNRevisionRange(startRev, SVNRevision.create((long)(endRev.getNumber() + 1L)));
                editedRevisionRangesList.add(revRange);
            }
            if (start.getNumber() < end.getNumber()) {
                start = end;
            } else {
                end = start;
            }
        }
        if (start != SVNRevision.UNDEFINED && end == SVNRevision.UNDEFINED) {
            end = start;
        } else if (start == SVNRevision.UNDEFINED) {
            start = target.getPegRevision() == SVNRevision.UNDEFINED ? (target.isURL() ? SVNRevision.HEAD : SVNRevision.BASE) : target.getPegRevision();
            if (end == SVNRevision.UNDEFINED) {
                end = SVNRevision.create((long)0L);
            }
        }
        if (target.isURL()) {
            for (int i = 1; i < targets.size(); ++i) {
                if (!SVNCommandUtil.isURL((String)targets.get(i))) continue;
                SVNErrorMessage err3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Only relative paths can be specified after a URL");
                SVNErrorManager.error((SVNErrorMessage)err3, (SVNLogType)SVNLogType.CLIENT);
            }
        } else if (targets.size() > 1) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"When specifying working copy paths, only one target may be given");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        this.myAuthorOfInterest = this.getSVNEnvironment().getAuthorOfInterest();
        this.myLogRegularExpression = this.getSVNEnvironment().getRegularExpression();
        this.myDepth = this.getSVNEnvironment().getDepth() == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.getSVNEnvironment().getDepth();
        this.myTarget = new SVNPath(target.getTarget(), target.getPegRevision() == SVNRevision.UNDEFINED ? (target.isURL() ? SVNRevision.HEAD : SVNRevision.WORKING) : target.getPegRevision());
        SVNLogClient client = this.getSVNEnvironment().getClientManager().getLogClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        String[] revProps = null;
        if (this.getSVNEnvironment().isXML()) {
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("log");
            }
            if (!this.getSVNEnvironment().isAllRevisionProperties() && this.getSVNEnvironment().getRevisionProperties() != null && !this.getSVNEnvironment().getRevisionProperties().isEmpty()) {
                SVNProperties revPropNames = this.getSVNEnvironment().getRevisionProperties();
                revProps = new String[revPropNames.size()];
                int i = 0;
                for (String propName : revPropNames.nameSet()) {
                    String propVal = revPropNames.getStringValue(propName);
                    if (propVal.length() > 0) {
                        SVNErrorMessage err4 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"cannot assign with 'with-revprop' option (drop the '=')");
                        SVNErrorManager.error((SVNErrorMessage)err4, (SVNLogType)SVNLogType.CLIENT);
                    }
                    revProps[i++] = propName;
                }
            } else if (!this.getSVNEnvironment().isAllRevisionProperties()) {
                revProps = !this.getSVNEnvironment().isQuiet() ? new String[]{"svn:author", "svn:date", "svn:log"} : new String[]{"svn:author", "svn:date"};
            }
        } else {
            revProps = !this.getSVNEnvironment().isQuiet() ? new String[]{"svn:author", "svn:date", "svn:log"} : new String[]{"svn:author", "svn:date"};
        }
        if (target.isFile()) {
            client.doLog(new File[]{target.getFile()}, editedRevisionRangesList, target.getPegRevision(), this.getSVNEnvironment().isStopOnCopy(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isUseMergeHistory(), this.getSVNEnvironment().getLimit(), revProps, (ISVNLogEntryHandler)this);
        } else {
            targets.remove(0);
            String[] paths = targets.toArray(new String[targets.size()]);
            client.doLog(target.getURL(), paths, target.getPegRevision(), editedRevisionRangesList, this.getSVNEnvironment().isStopOnCopy(), this.getSVNEnvironment().isVerbose(), this.getSVNEnvironment().isUseMergeHistory(), this.getSVNEnvironment().getLimit(), revProps, (ISVNLogEntryHandler)this);
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("log");
        } else if (!this.getSVNEnvironment().isIncremental()) {
            this.getSVNEnvironment().getOut().print(SEPARATOR);
        }
    }

    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        if (!this.getSVNEnvironment().isXML()) {
            this.printLogEntry(logEntry);
        } else {
            this.printLogEntryXML(logEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printLogEntry(SVNLogEntry logEntry) throws SVNException {
        String date;
        SVNDate dateObject;
        if (logEntry == null) {
            return;
        }
        if (this.myAuthorOfInterest != null && !"".equals(this.myAuthorOfInterest) && !this.myAuthorOfInterest.equals(logEntry.getAuthor())) {
            return;
        }
        SVNProperties revisionProperties = logEntry.getRevisionProperties();
        String author = revisionProperties.getStringValue("svn:author");
        String message = revisionProperties.getStringValue("svn:log");
        String dateValue = revisionProperties.getStringValue("svn:date");
        SVNDate sVNDate = dateObject = dateValue == null ? null : SVNDate.parseDate((String)dateValue);
        if (message == null && logEntry.getRevision() == 0L) {
            return;
        }
        if (!SVNRevision.isValidRevisionNumber((long)logEntry.getRevision())) {
            if (!this.myMergeStack.isEmpty()) {
                this.myMergeStack.removeLast();
            }
            return;
        }
        if (this.myLogRegularExpression != null) {
            if (message == null) {
                return;
            }
            String[] result = null;
            try {
                result = message.split(this.myLogRegularExpression);
            }
            catch (PatternSyntaxException psy) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"you specified an invalid regular expression: {0}", (Object)psy.getMessage());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if (result.length == 1 && message.equals(result[0]) && !message.equals(this.myLogRegularExpression)) {
                return;
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (author == null) {
            author = "(no author)";
        }
        String string = date = dateObject == null ? "(no date)" : SVNDate.formatHumanDate((Date)dateObject, (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions());
        if (!this.getSVNEnvironment().isQuiet() && message == null) {
            message = "";
        }
        buffer.append(SEPARATOR);
        buffer.append("r" + Long.toString(logEntry.getRevision()) + " | " + author + " | " + date);
        if (message != null) {
            int count = SVNCommandUtil.getLinesCount(message);
            buffer.append(" | " + count + (count == 1 ? " line" : " lines"));
        }
        buffer.append("\n");
        if (this.getSVNEnvironment().isVerbose() && logEntry.getChangedPaths() != null) {
            TreeMap sortedPaths = new TreeMap(logEntry.getChangedPaths());
            buffer.append("Changed paths:\n");
            for (String path : sortedPaths.keySet()) {
                SVNLogEntryPath lPath = (SVNLogEntryPath)sortedPaths.get(path);
                buffer.append("   " + lPath.getType() + " " + path);
                if (lPath.getCopyPath() != null) {
                    buffer.append(" (from " + lPath.getCopyPath() + ":" + lPath.getCopyRevision() + ")");
                }
                buffer.append("\n");
            }
        }
        if (this.myMergeStack != null && !this.myMergeStack.isEmpty()) {
            buffer.append(logEntry.isSubtractiveMerge() ? "Reverse merged via:" : "Merged via:");
            Iterator revs = this.myMergeStack.iterator();
            while (revs.hasNext()) {
                long rev = (Long)revs.next();
                buffer.append(" r");
                buffer.append(rev);
                if (revs.hasNext()) {
                    buffer.append(',');
                    continue;
                }
                buffer.append('\n');
            }
        }
        if (message != null) {
            buffer.append("\n" + message + "\n");
        }
        if (logEntry.hasChildren()) {
            Long rev = new Long(logEntry.getRevision());
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(rev);
        }
        this.getSVNEnvironment().getOut().print(buffer.toString());
        if (this.getSVNEnvironment().isShowDiff()) {
            block33: {
                this.getSVNEnvironment().getOut().println();
                SVNClientManager diffClientManager = this.getEnvironment().createClientManager();
                try {
                    SVNDiffClient client = diffClientManager.getDiffClient();
                    client.setShowCopiesAsAdds(false);
                    SvnNewDiffGenerator diffGenerator = SVNDiffCommand.createDiffGenerator(this.getSVNEnvironment());
                    diffGenerator.setDiffDeleted(false);
                    client.setDiffGenerator((ISVNDiffGenerator)diffGenerator);
                    try {
                        this.doDiff(client, logEntry, this.myTarget, this.myDepth);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                            SVNPath parent = this.getParentPath(this.myTarget);
                            if (this.myTarget.equals(parent)) break block33;
                            try {
                                this.doDiff(client, logEntry, parent, this.myDepth);
                                break block33;
                            }
                            catch (SVNException e1) {
                                if (e1.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                                    parent = this.getParentPath(parent);
                                    break block33;
                                }
                                if (e1.getErrorMessage().getErrorCode() == SVNErrorCode.RA_ILLEGAL_URL || e1.getErrorMessage().getErrorCode() == SVNErrorCode.AUTHZ_UNREADABLE) break block33;
                                if (e1.getErrorMessage().getErrorCode() == SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED) {
                                    break block33;
                                }
                                throw e1;
                            }
                        }
                        throw e;
                    }
                }
                finally {
                    diffClientManager.dispose();
                }
            }
            this.getSVNEnvironment().getOut().println();
        }
    }

    private SVNPath getParentPath(SVNPath target) {
        return new SVNPath(SVNPathUtil.removeTail((String)target.getTarget()), target.getPegRevision());
    }

    private void doDiff(SVNDiffClient client, SVNLogEntry logEntry, SVNPath target, SVNDepth depth) throws SVNException {
        if (target.isFile()) {
            client.doDiff(target.getFile(), target.getPegRevision(), SVNRevision.create((long)(logEntry.getRevision() - 1L)), SVNRevision.create((long)logEntry.getRevision()), depth, true, (OutputStream)this.getSVNEnvironment().getOut(), this.getSVNEnvironment().getChangelistsCollection());
        } else {
            client.doDiff(target.getURL(), target.getPegRevision(), SVNRevision.create((long)(logEntry.getRevision() - 1L)), SVNRevision.create((long)logEntry.getRevision()), depth, true, (OutputStream)this.getSVNEnvironment().getOut());
        }
    }

    protected void printLogEntryXML(SVNLogEntry logEntry) throws SVNException {
        SVNDate dateObject;
        if (logEntry == null) {
            return;
        }
        if (this.myAuthorOfInterest != null && !"".equals(this.myAuthorOfInterest) && !this.myAuthorOfInterest.equals(logEntry.getAuthor())) {
            return;
        }
        SVNProperties revProps = logEntry.getRevisionProperties();
        String author = revProps.getStringValue("svn:author");
        String message = revProps.getStringValue("svn:log");
        String dateValue = revProps.getStringValue("svn:date");
        SVNDate sVNDate = dateObject = dateValue == null ? null : SVNDate.parseDate((String)dateValue);
        if (logEntry.getRevision() == 0L && message == null) {
            return;
        }
        if (this.myLogRegularExpression != null) {
            if (message == null) {
                return;
            }
            String[] result = null;
            try {
                result = message.split(this.myLogRegularExpression);
            }
            catch (PatternSyntaxException psy) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"you specified an invalid regular expression: {0}", (Object)psy.getMessage());
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            if (result.length == 1 && message.equals(result[0]) && !message.equals(this.myLogRegularExpression)) {
                return;
            }
        }
        if (author != null) {
            author = SVNEncodingUtil.fuzzyEscape((String)author);
        }
        if (message != null) {
            message = SVNEncodingUtil.fuzzyEscape((String)message);
        }
        StringBuffer buffer = new StringBuffer();
        if (!SVNRevision.isValidRevisionNumber((long)logEntry.getRevision())) {
            buffer = this.closeXMLTag("logentry", null);
            this.getSVNEnvironment().getOut().print(buffer.toString());
            if (!this.myMergeStack.isEmpty()) {
                this.myMergeStack.removeLast();
            }
            return;
        }
        buffer = this.openXMLTag("logentry", 1, "revision", Long.toString(logEntry.getRevision()), buffer);
        buffer = this.openCDataTag("author", author, buffer);
        if (dateObject != null && dateObject.getTime() != 0L) {
            String dateString = SVNEncodingUtil.fuzzyEscape((String)dateObject.format());
            buffer = this.openCDataTag("date", dateString, buffer);
        }
        if (logEntry.getChangedPaths() != null && !logEntry.getChangedPaths().isEmpty()) {
            buffer = this.openXMLTag("paths", 1, null, buffer);
            for (String key : logEntry.getChangedPaths().keySet()) {
                SVNLogEntryPath path = (SVNLogEntryPath)logEntry.getChangedPaths().get(key);
                LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                if (path.getKind() != null) {
                    attrs.put("kind", path.getKind() + "");
                }
                attrs.put("action", path.getType() + "");
                if (path.getCopyPath() != null) {
                    attrs.put("copyfrom-path", path.getCopyPath());
                    attrs.put("copyfrom-rev", Long.toString(path.getCopyRevision()));
                }
                buffer = this.openXMLTag("path", 2, attrs, buffer);
                buffer.append(SVNEncodingUtil.xmlEncodeCDATA((String)path.getPath()));
                buffer = this.closeXMLTag("path", buffer);
            }
            buffer = this.closeXMLTag("paths", buffer);
        }
        if (message != null) {
            buffer = this.openCDataTag("msg", message, buffer);
        }
        if (revProps != null) {
            revProps.remove("svn:author");
            revProps.remove("svn:date");
            revProps.remove("svn:log");
        }
        if (revProps != null && !revProps.isEmpty()) {
            buffer = this.openXMLTag("revprops", 1, null, buffer);
            buffer = this.printXMLPropHash(buffer, revProps, false, false);
            buffer = this.closeXMLTag("revprops", buffer);
        }
        if (logEntry.hasChildren()) {
            if (this.myMergeStack == null) {
                this.myMergeStack = new LinkedList();
            }
            this.myMergeStack.addLast(new Long(logEntry.getRevision()));
        } else {
            buffer = this.closeXMLTag("logentry", buffer);
        }
        this.getSVNEnvironment().getOut().print(buffer.toString());
    }
}

