/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookInfoCommand
extends SVNLookCommand {
    public SVNLookInfoCommand() {
        super("info", null);
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        SVNLogEntry logEntry = null;
        logEntry = environment.isRevision() ? client.doGetInfo(environment.getRepositoryFile(), this.getRevisionObject()) : client.doGetInfo(environment.getRepositoryFile(), environment.getTransaction());
        String author = logEntry.getAuthor() != null ? logEntry.getAuthor() : "";
        String date = logEntry.getDate() != null ? SVNDate.formatCustomDate((Date)logEntry.getDate()) : "";
        String log = logEntry.getMessage() != null ? logEntry.getMessage() : "";
        environment.getOut().println(author);
        environment.getOut().println(date);
        if (log == null || log.length() == 0) {
            environment.getOut().println("0");
        } else {
            environment.getOut().println(String.valueOf(log.length()));
            environment.getOut().println(log);
        }
    }
}

